/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountObjectStrategy;
import org.apache.druid.query.aggregation.exact.count.bitmap64.RoaringBitmap64Counter;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class Bitmap64ExactCountMergeComplexMetricSerde
extends ComplexMetricSerde {
    static RoaringBitmap64Counter deserializeRoaringBitmap64Counter(Object object) {
        if (object instanceof String) {
            return RoaringBitmap64Counter.fromBytes(Bitmap64ExactCountMergeComplexMetricSerde.decodeStringToByteArray((String)object));
        }
        if (object instanceof byte[]) {
            return RoaringBitmap64Counter.fromBytes((byte[])object);
        }
        if (object instanceof RoaringBitmap64Counter) {
            return (RoaringBitmap64Counter)object;
        }
        throw new IAE("Cannot deserialize type[%s] to an RoaringBitmap64Counter:", new Object[]{object.getClass().getName()});
    }

    private static byte[] decodeStringToByteArray(String string) {
        try {
            return StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)string));
        }
        catch (IllegalArgumentException e) {
            throw new IAE("Failed to deserialize to RoaringBitmap64Counter, input is an invalid base64 string", new Object[0]);
        }
    }

    public String getTypeName() {
        return "Bitmap64ExactCount";
    }

    public ObjectStrategy getObjectStrategy() {
        return Bitmap64ExactCountObjectStrategy.STRATEGY;
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<?> extractedClass() {
                return RoaringBitmap64Counter.class;
            }

            public RoaringBitmap64Counter extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object == null) {
                    return null;
                }
                return Bitmap64ExactCountMergeComplexMetricSerde.deserializeRoaringBitmap64Counter(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buf, ColumnBuilder columnBuilder) {
        columnBuilder.setComplexColumnSupplier((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), GenericIndexed.read((ByteBuffer)buf, (ObjectStrategy)Bitmap64ExactCountObjectStrategy.STRATEGY, (SegmentFileMapper)columnBuilder.getFileMapper())));
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, (ObjectStrategy)this.getObjectStrategy());
    }
}

