/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountAggregatorFactory;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountBuildAggregator;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountBuildBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class Bitmap64ExactCountBuildAggregatorFactory
extends Bitmap64ExactCountAggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"Bitmap64ExactCountBuild");

    @JsonCreator
    public Bitmap64ExactCountBuildAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        super(name, fieldName);
    }

    @Override
    protected byte getCacheTypeId() {
        return 96;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        this.validateNumericColumn(metricFactory);
        return new Bitmap64ExactCountBuildAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.getFieldName()));
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        this.validateNumericColumn(metricFactory);
        return new Bitmap64ExactCountBuildBufferAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.getFieldName()));
    }

    public ColumnType getIntermediateType() {
        return TYPE;
    }

    public ColumnType getResultType() {
        return ColumnType.LONG;
    }

    private void validateNumericColumn(ColumnSelectorFactory metricFactory) {
        ValueType valueType;
        ColumnCapabilities capabilities = metricFactory.getColumnCapabilities(this.getFieldName());
        if (capabilities != null && !(valueType = (ValueType)capabilities.getType()).isNumeric()) {
            throw new IAE("Aggregation [%s] does not support column [%s] of type [%s]. Supported types: numeric.", new Object[]{"Bitmap64ExactCountBuild", this.getFieldName(), valueType});
        }
    }
}

