/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountMergeAggregatorFactory;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountMergeComplexMetricSerde;
import org.apache.druid.query.aggregation.exact.count.bitmap64.RoaringBitmap64Counter;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class Bitmap64ExactCountAggregatorFactory
extends AggregatorFactory {
    static final int MAX_INTERMEDIATE_SIZE = 1024;
    static final Comparator<Bitmap64> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(Bitmap64::getCardinality));
    @Nonnull
    private final String name;
    @Nonnull
    private final String fieldName;

    Bitmap64ExactCountAggregatorFactory(String name, String fieldName) {
        this.name = Objects.requireNonNull(name);
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    @Nonnull
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nonnull
    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Nonnull
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public Bitmap64 deserialize(Object object) {
        return Bitmap64ExactCountMergeComplexMetricSerde.deserializeRoaringBitmap64Counter(object);
    }

    public Bitmap64 combine(Object objectA, Object objectB) {
        if (objectB == null) {
            return (Bitmap64)objectA;
        }
        if (objectA == null) {
            return (Bitmap64)objectB;
        }
        return ((Bitmap64)objectA).fold((Bitmap64)objectB);
    }

    public AggregateCombiner<Bitmap64> makeAggregateCombiner() {
        return new ObjectAggregateCombiner<Bitmap64>(){
            private Bitmap64 union = new RoaringBitmap64Counter();

            public void reset(ColumnValueSelector selector) {
                this.union = new RoaringBitmap64Counter();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                Bitmap64 bitmap64Counter = (Bitmap64)selector.getObject();
                this.union.fold(bitmap64Counter);
            }

            @Nullable
            public Bitmap64 getObject() {
                return this.union;
            }

            public Class<Bitmap64> classOfObject() {
                return Bitmap64.class;
            }
        };
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return ((Bitmap64)object).getCardinality();
    }

    public Comparator<Bitmap64> getComparator() {
        return COMPARATOR;
    }

    public AggregatorFactory getCombiningFactory() {
        return new Bitmap64ExactCountMergeAggregatorFactory(this.getName(), this.getName());
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.getCacheTypeId()).appendString(this.name).appendString(this.fieldName).build();
    }

    public int getMaxIntermediateSize() {
        return 1024;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        Bitmap64ExactCountAggregatorFactory that = (Bitmap64ExactCountAggregatorFactory)((Object)object);
        if (!this.name.equals(that.getName())) {
            return false;
        }
        return this.fieldName.equals(that.getFieldName());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " { name=" + this.name + ", fieldName=" + this.fieldName + " }";
    }

    protected abstract byte getCacheTypeId();
}

