/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64;
import org.apache.druid.query.aggregation.exact.count.bitmap64.RoaringBitmap64Counter;
import org.apache.druid.segment.ColumnValueSelector;

public class Bitmap64ExactCountMergeBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector<Bitmap64> selector;
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<Bitmap64>> counterCache = new IdentityHashMap();

    public Bitmap64ExactCountMergeBufferAggregator(ColumnValueSelector<Bitmap64> selector) {
        this.selector = selector;
    }

    public void init(ByteBuffer buf, int position) {
        RoaringBitmap64Counter emptyCounter = new RoaringBitmap64Counter();
        this.addToCache(buf, position, emptyCounter);
    }

    public void aggregate(ByteBuffer buf, int position) {
        Object x = this.selector.getObject();
        if (x == null) {
            return;
        }
        Bitmap64 bitmap64Counter = (Bitmap64)this.counterCache.get(buf).get(position);
        bitmap64Counter.fold((RoaringBitmap64Counter)x);
    }

    public Object get(ByteBuffer buf, int position) {
        return this.counterCache.get(buf).get(position);
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.counterCache.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        Bitmap64 counter = (Bitmap64)this.counterCache.get(oldBuffer).get(oldPosition);
        this.addToCache(newBuffer, newPosition, counter);
        Int2ObjectMap<Bitmap64> counterMap = this.counterCache.get(oldBuffer);
        if (counterMap != null) {
            counterMap.remove(oldPosition);
            if (counterMap.isEmpty()) {
                this.counterCache.remove(oldBuffer);
            }
        }
    }

    private void addToCache(ByteBuffer buffer, int position, Bitmap64 counter) {
        Int2ObjectMap map = this.counterCache.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)counter);
    }
}

