/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.distinctcount;

import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class DistinctCountAggregator
implements Aggregator {
    private final DimensionSelector selector;
    private final MutableBitmap mutableBitmap;

    public DistinctCountAggregator(DimensionSelector selector, MutableBitmap mutableBitmap) {
        this.selector = selector;
        this.mutableBitmap = mutableBitmap;
    }

    public void aggregate() {
        IndexedInts row = this.selector.getRow();
        int rowSize = row.size();
        for (int i = 0; i < rowSize; ++i) {
            int index = row.get(i);
            this.mutableBitmap.add(index);
        }
    }

    public Object get() {
        return this.mutableBitmap.size();
    }

    public float getFloat() {
        return this.mutableBitmap.size();
    }

    public void close() {
        this.mutableBitmap.clear();
    }

    public long getLong() {
        return this.mutableBitmap.size();
    }

    public double getDouble() {
        return this.mutableBitmap.size();
    }
}

