/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.distinctcount;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class DistinctCountBufferAggregator
implements BufferAggregator {
    private final DimensionSelector selector;
    private final Int2ObjectMap<MutableBitmap> mutableBitmapCollection = new Int2ObjectOpenHashMap();

    public DistinctCountBufferAggregator(DimensionSelector selector) {
        this.selector = selector;
    }

    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    public void aggregate(ByteBuffer buf, int position) {
        MutableBitmap mutableBitmap = this.getMutableBitmap(position);
        IndexedInts row = this.selector.getRow();
        int rowSize = row.size();
        for (int i = 0; i < rowSize; ++i) {
            int index = row.get(i);
            mutableBitmap.add(index);
        }
        buf.putLong(position, mutableBitmap.size());
    }

    private MutableBitmap getMutableBitmap(int position) {
        MutableBitmap mutableBitmap = (MutableBitmap)this.mutableBitmapCollection.get(position);
        if (mutableBitmap == null) {
            mutableBitmap = new WrappedRoaringBitmap();
            this.mutableBitmapCollection.put(position, (Object)mutableBitmap);
        }
        return mutableBitmap;
    }

    public Object get(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public double getDouble(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public void close() {
        this.mutableBitmapCollection.clear();
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (HotLoopCallee)this.selector);
    }
}

