/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.distinctcount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.LongSumAggregateCombiner;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.distinctcount.BitMapFactory;
import org.apache.druid.query.aggregation.distinctcount.DistinctCountAggregator;
import org.apache.druid.query.aggregation.distinctcount.DistinctCountBufferAggregator;
import org.apache.druid.query.aggregation.distinctcount.NoopDistinctCountAggregator;
import org.apache.druid.query.aggregation.distinctcount.NoopDistinctCountBufferAggregator;
import org.apache.druid.query.aggregation.distinctcount.RoaringBitMapFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnType;

public class DistinctCountAggregatorFactory
extends AggregatorFactory {
    private static final BitMapFactory DEFAULT_BITMAP_FACTORY = new RoaringBitMapFactory();
    private final String name;
    private final String fieldName;
    private final BitMapFactory bitMapFactory;

    @JsonCreator
    public DistinctCountAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="bitmapFactory") BitMapFactory bitMapFactory) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)fieldName);
        this.name = name;
        this.fieldName = fieldName;
        this.bitMapFactory = bitMapFactory == null ? DEFAULT_BITMAP_FACTORY : bitMapFactory;
    }

    public Aggregator factorize(ColumnSelectorFactory columnFactory) {
        DimensionSelector selector = this.makeDimensionSelector(columnFactory);
        if (selector == null) {
            return new NoopDistinctCountAggregator();
        }
        return new DistinctCountAggregator(selector, this.bitMapFactory.makeEmptyMutableBitmap());
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnFactory) {
        DimensionSelector selector = this.makeDimensionSelector(columnFactory);
        if (selector == null) {
            return NoopDistinctCountBufferAggregator.instance();
        }
        return new DistinctCountBufferAggregator(this.makeDimensionSelector(columnFactory));
    }

    public AggregatorFactory withName(String newName) {
        return new DistinctCountAggregatorFactory(newName, this.getFieldName(), this.getBitMapFactory());
    }

    private DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnFactory) {
        return columnFactory.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(this.fieldName, this.fieldName));
    }

    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o, Object o1) {
                return Longs.compare((long)((Number)o).longValue(), (long)((Number)o1).longValue());
            }
        };
    }

    public Object combine(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return 0L;
        }
        if (rhs == null) {
            return ((Number)lhs).longValue();
        }
        if (lhs == null) {
            return ((Number)rhs).longValue();
        }
        return ((Number)lhs).longValue() + ((Number)rhs).longValue();
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new LongSumAggregateCombiner();
    }

    public AggregatorFactory getCombiningFactory() {
        return new LongSumAggregatorFactory(this.name, this.name);
    }

    public Object deserialize(Object object) {
        return object;
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty(value="bitmapFactory")
    public BitMapFactory getBitMapFactory() {
        return this.bitMapFactory;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        byte[] bitMapFactoryCacheKey = StringUtils.toUtf8((String)this.bitMapFactory.toString());
        return ByteBuffer.allocate(2 + fieldNameBytes.length + bitMapFactoryCacheKey.length).put((byte)16).put(fieldNameBytes).put((byte)-1).put(bitMapFactoryCacheKey).array();
    }

    public ColumnType getIntermediateType() {
        return ColumnType.LONG;
    }

    public ColumnType getResultType() {
        return ColumnType.LONG;
    }

    public int getMaxIntermediateSize() {
        return 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistinctCountAggregatorFactory that = (DistinctCountAggregatorFactory)((Object)o);
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }

    public String toString() {
        return "DistinctCountAggregatorFactory{name='" + this.name + "', fieldName='" + this.fieldName + "'}";
    }
}

