/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal.aggregator.max;

import java.nio.ByteBuffer;
import org.apache.druid.compressedbigdecimal.ByteBufferCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.Utils;
import org.apache.druid.compressedbigdecimal.aggregator.CompressedBigDecimalBufferAggregatorBase;
import org.apache.druid.segment.ColumnValueSelector;

public class CompressedBigDecimalMaxBufferAggregator
extends CompressedBigDecimalBufferAggregatorBase {
    private static final int HEADER_SIZE_BYTES = 1;

    public CompressedBigDecimalMaxBufferAggregator(int size, int scale, ColumnValueSelector<CompressedBigDecimal> selector, boolean strictNumberParsing) {
        super(size, scale, selector, strictNumberParsing, 1);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBufferCompressedBigDecimal.initMin(buf, position + 1, this.size);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        CompressedBigDecimal addend = Utils.objToCompressedBigDecimalWithScale(this.selector.getObject(), this.scale, this.strictNumberParsing);
        if (addend != null) {
            this.setEmpty(false, buf, position);
            ByteBufferCompressedBigDecimal existing = new ByteBufferCompressedBigDecimal(buf, position + 1, this.size, this.scale);
            existing.accumulateMax(addend);
        }
    }
}

