/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalColumn;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.druid.segment.file.SegmentFileMapper;

public class CompressedBigDecimalColumnPartSupplier
implements Supplier<ComplexColumn> {
    public static final int VERSION = 1;
    private final int byteSize;
    private final CompressedVSizeColumnarIntsSupplier scaleSupplier;
    private final V3CompressedVSizeColumnarMultiIntsSupplier magnitudeSupplier;

    public static CompressedBigDecimalColumnPartSupplier fromByteBuffer(ByteBuffer buffer, SegmentFileMapper fileMapper) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1) {
            int positionStart = buffer.position();
            CompressedVSizeColumnarIntsSupplier scaleSupplier = CompressedVSizeColumnarIntsSupplier.fromByteBuffer((ByteBuffer)buffer, (ByteOrder)IndexIO.BYTE_ORDER, (SegmentFileMapper)fileMapper);
            V3CompressedVSizeColumnarMultiIntsSupplier magnitudeSupplier = V3CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer((ByteBuffer)buffer, (ByteOrder)IndexIO.BYTE_ORDER, (SegmentFileMapper)fileMapper);
            return new CompressedBigDecimalColumnPartSupplier(buffer.position() - positionStart, scaleSupplier, magnitudeSupplier);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    public CompressedBigDecimalColumnPartSupplier(int byteSize, CompressedVSizeColumnarIntsSupplier scaleSupplier, V3CompressedVSizeColumnarMultiIntsSupplier magnitudeSupplier) {
        this.byteSize = byteSize;
        this.scaleSupplier = scaleSupplier;
        this.magnitudeSupplier = magnitudeSupplier;
    }

    public ComplexColumn get() {
        return new CompressedBigDecimalColumn(this.byteSize, this.scaleSupplier.get(), this.magnitudeSupplier.get());
    }
}

