/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal.aggregator.sum;

import java.nio.ByteBuffer;
import org.apache.druid.compressedbigdecimal.ByteBufferCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.Utils;
import org.apache.druid.compressedbigdecimal.aggregator.CompressedBigDecimalBufferAggregatorBase;
import org.apache.druid.segment.ColumnValueSelector;

public class CompressedBigDecimalSumBufferAggregator
extends CompressedBigDecimalBufferAggregatorBase {
    public CompressedBigDecimalSumBufferAggregator(int size, int scale, ColumnValueSelector<CompressedBigDecimal> selector, boolean strictNumberParsing) {
        super(size, scale, selector, strictNumberParsing, 0);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBufferCompressedBigDecimal.initZero(buf, position, this.size);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        CompressedBigDecimal addend = Utils.objToCompressedBigDecimalWithScale(this.selector.getObject(), this.scale, this.strictNumberParsing);
        if (addend != null) {
            ByteBufferCompressedBigDecimal existing = new ByteBufferCompressedBigDecimal(buf, position, this.size, this.scale);
            existing.accumulateSum(addend);
        }
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support getLong()");
    }

    @Override
    public void close() {
    }
}

