/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import org.apache.druid.storage.cloudfiles.CloudFilesObject;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.rackspace.cloudfiles.v1.CloudFilesApi;

public class CloudFilesObjectApiProxy {
    private final ObjectApi objectApi;
    private final String region;
    private final String container;

    public CloudFilesObjectApiProxy(CloudFilesApi cloudFilesApi, String region, String container) {
        this.region = region;
        this.container = container;
        this.objectApi = cloudFilesApi.getObjectApi(region, container);
    }

    public String getRegion() {
        return this.region;
    }

    public String getContainer() {
        return this.container;
    }

    public String put(CloudFilesObject cloudFilesObject) {
        return this.objectApi.put(cloudFilesObject.getPath(), cloudFilesObject.getPayload());
    }

    public CloudFilesObject get(String path, long start) {
        SwiftObject swiftObject = start == 0L ? this.objectApi.get(path) : this.objectApi.get(path, new GetOptions().startAt(start));
        Payload payload = swiftObject.getPayload();
        return new CloudFilesObject(payload, this.region, this.container, path);
    }

    public boolean exists(String path) {
        return this.objectApi.getWithoutBody(path) != null;
    }
}

