/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import org.apache.druid.storage.cloudfiles.CloudFilesObjectApiProxy;
import org.apache.druid.storage.cloudfiles.CloudFilesUtils;
import org.jclouds.io.Payload;

public class CloudFilesByteSource
extends ByteSource {
    private final CloudFilesObjectApiProxy objectApi;
    private final String path;
    private Payload payload;

    public CloudFilesByteSource(CloudFilesObjectApiProxy objectApi, String path) {
        this.objectApi = objectApi;
        this.path = path;
        this.payload = null;
    }

    public void closeStream() throws IOException {
        if (this.payload != null) {
            this.payload.close();
            this.payload = null;
        }
    }

    public InputStream openStream() throws IOException {
        return this.openStream(0L);
    }

    public InputStream openStream(long start) throws IOException {
        this.payload = this.payload == null ? this.objectApi.get(this.path, start).getPayload() : this.payload;
        try {
            return this.payload.openStream();
        }
        catch (IOException e) {
            if (CloudFilesUtils.CLOUDFILESRETRY.apply((Object)e)) {
                throw new IOException("Recoverable exception", e);
            }
            throw new RuntimeException(e);
        }
    }
}

