/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.dropwizard;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.emitter.dropwizard.DropwizardEmitter;
import org.apache.druid.emitter.dropwizard.DropwizardEmitterConfig;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.emitter.core.Emitter;

public class DropwizardEmitterModule
implements DruidModule {
    private static final String EMITTER_TYPE = "dropwizard";

    public List<? extends Module> getJacksonModules() {
        return Collections.emptyList();
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.dropwizard", DropwizardEmitterConfig.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="dropwizard")
    public Emitter getEmitter(DropwizardEmitterConfig dropwizardEmitterConfig, ObjectMapper mapper, Injector injector) {
        List<Emitter> alertEmitters = dropwizardEmitterConfig.getAlertEmitters().stream().map(s -> (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)s)))).collect(Collectors.toList());
        return new DropwizardEmitter(dropwizardEmitterConfig, mapper, alertEmitters);
    }
}

