/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.emitter.dropwizard.DropwizardConverter;
import org.apache.druid.emitter.dropwizard.DropwizardEmitterConfig;
import org.apache.druid.emitter.dropwizard.DropwizardMetricSpec;
import org.apache.druid.emitter.dropwizard.DropwizardReporter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.SegmentMetadataEvent;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

public class DropwizardEmitter
implements Emitter {
    private static final Logger log = new Logger(DropwizardEmitter.class);
    private final MetricRegistry metricsRegistry;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final DropwizardConverter converter;
    private final List<Emitter> alertEmitters;
    private final List<DropwizardReporter> reporters;
    private final DropwizardEmitterConfig config;

    public DropwizardEmitter(DropwizardEmitterConfig config, ObjectMapper mapper, List<Emitter> alertEmitters) {
        this.alertEmitters = alertEmitters;
        this.config = config;
        this.reporters = config.getReporters();
        this.converter = new DropwizardConverter(mapper, config.getDimensionMapPath());
        final Cache metricsRegistryCache = Caffeine.newBuilder().recordStats().maximumSize((long)config.getMaxMetricsRegistrySize()).build();
        this.metricsRegistry = new MetricRegistry(){

            protected ConcurrentMap<String, Metric> buildMap() {
                return metricsRegistryCache.asMap();
            }
        };
    }

    public void start() {
        boolean alreadyStarted = this.started.getAndSet(true);
        if (!alreadyStarted) {
            for (DropwizardReporter reporter : this.reporters) {
                reporter.start(this.metricsRegistry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(Event event) {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                throw new RejectedExecutionException("Dropwizard emitter Service not started.");
            }
        }
        if (event instanceof ServiceMetricEvent) {
            ServiceMetricEvent metricEvent = (ServiceMetricEvent)event;
            String host = metricEvent.getHost();
            String service = metricEvent.getService();
            String metric = metricEvent.getMetric();
            Map userDims = metricEvent.getUserDims();
            Number value = metricEvent.getValue();
            ImmutableList.Builder nameBuilder = new ImmutableList.Builder();
            LinkedHashMap<String, String> dims = new LinkedHashMap<String, String>();
            DropwizardMetricSpec metricSpec = this.converter.addFilteredUserDims(service, metric, userDims, dims);
            if (metricSpec != null) {
                if (this.config.getPrefix() != null) {
                    nameBuilder.add((Object)this.config.getPrefix());
                }
                nameBuilder.add((Object)StringUtils.format((String)"metric=%s", (Object[])new Object[]{metric}));
                nameBuilder.add((Object)StringUtils.format((String)"service=%s", (Object[])new Object[]{service}));
                if (this.config.getIncludeHost().booleanValue()) {
                    nameBuilder.add((Object)StringUtils.format((String)"hostname=%s", (Object[])new Object[]{host}));
                }
                dims.forEach((key, value1) -> nameBuilder.add((Object)StringUtils.format((String)"%s=%s", (Object[])new Object[]{key, value1})));
                String fullName = StringUtils.replaceChar((String)Joiner.on((String)",").join((Iterable)nameBuilder.build()), (char)'/', (String)".");
                this.updateMetric(fullName, value, metricSpec);
            } else {
                log.debug("Service=[%s], Metric=[%s] has no mapping", new Object[]{service, metric});
            }
        } else if (event instanceof AlertEvent) {
            for (Emitter emitter : this.alertEmitters) {
                emitter.emit(event);
            }
        } else if (!(event instanceof SegmentMetadataEvent)) {
            throw new ISE("unknown event type [%s]", new Object[]{event.getClass()});
        }
    }

    private void updateMetric(String name, Number value, DropwizardMetricSpec metricSpec) {
        switch (metricSpec.getType()) {
            case meter: {
                this.metricsRegistry.meter(name).mark(value.longValue());
                break;
            }
            case timer: {
                this.metricsRegistry.timer(name).update(value.longValue(), metricSpec.getTimeUnit());
                break;
            }
            case counter: {
                this.metricsRegistry.counter(name).inc(value.longValue());
                break;
            }
            case histogram: {
                this.metricsRegistry.histogram(name).update(value.longValue());
                break;
            }
            case gauge: {
                SettableGauge gauge = (SettableGauge)this.metricsRegistry.gauge(name, () -> new SettableGauge(value));
                gauge.setValue(value);
                break;
            }
            default: {
                throw new ISE("Unknown Metric Type [%s]", new Object[]{metricSpec.getType()});
            }
        }
    }

    public void flush() {
        for (DropwizardReporter reporter : this.reporters) {
            reporter.flush();
        }
    }

    public void close() {
        boolean wasStarted = this.started.getAndSet(false);
        if (wasStarted) {
            for (DropwizardReporter reporter : this.reporters) {
                reporter.close();
            }
        }
    }

    private static class SettableGauge
    implements Gauge<Number> {
        private Number value;

        public SettableGauge(Number value) {
            this.value = value;
        }

        public void setValue(Number value) {
            this.value = value;
        }

        public Number getValue() {
            return this.value;
        }
    }
}

