/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner.convertlet;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.druid.sql.calcite.expression.builtin.NestedDataOperatorConversions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.convertlet.CurrentTimestampAndFriendsConvertletFactory;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletFactory;
import org.apache.druid.sql.calcite.planner.convertlet.TimeInIntervalConvertletFactory;

public class DruidConvertletTable
implements SqlRexConvertletTable {
    private static final SqlRexConvertlet BYPASS_CONVERTLET = (arg_0, arg_1) -> ((StandardConvertletTable)StandardConvertletTable.INSTANCE).convertCall(arg_0, arg_1);
    private static final List<DruidConvertletFactory> DRUID_CONVERTLET_FACTORIES = ImmutableList.builder().add((Object)CurrentTimestampAndFriendsConvertletFactory.INSTANCE).add((Object)TimeInIntervalConvertletFactory.INSTANCE).add((Object)NestedDataOperatorConversions.DRUID_JSON_VALUE_CONVERTLET_FACTORY_INSTANCE).build();
    private static final List<SqlOperator> STANDARD_CONVERTLET_OPERATORS = ImmutableList.builder().add((Object)SqlStdOperatorTable.ROW).add((Object)SqlStdOperatorTable.NOT_IN).add((Object)SqlStdOperatorTable.NOT_LIKE).add((Object)SqlStdOperatorTable.BETWEEN).add((Object)SqlStdOperatorTable.NOT_BETWEEN).add((Object)SqlStdOperatorTable.SYMMETRIC_BETWEEN).add((Object)SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN).add((Object)SqlStdOperatorTable.ITEM).add((Object)SqlStdOperatorTable.TIMESTAMP_ADD).add((Object)SqlStdOperatorTable.TIMESTAMP_DIFF).add((Object)SqlStdOperatorTable.UNION).add((Object)SqlStdOperatorTable.UNION_ALL).add((Object)SqlStdOperatorTable.NULLIF).add((Object)SqlStdOperatorTable.DESC).add((Object)SqlStdOperatorTable.NULLS_FIRST).add((Object)SqlStdOperatorTable.NULLS_LAST).build();
    private final Map<SqlOperator, SqlRexConvertlet> table;

    public DruidConvertletTable(PlannerContext plannerContext) {
        this.table = DruidConvertletTable.createConvertletMap(plannerContext);
    }

    public SqlRexConvertlet get(SqlCall call) {
        if (call.getKind() == SqlKind.EXTRACT && ((SqlNode)call.getOperandList().get(1)).getKind() != SqlKind.LITERAL) {
            return BYPASS_CONVERTLET;
        }
        SqlRexConvertlet convertlet = this.table.get(call.getOperator());
        return convertlet != null ? convertlet : StandardConvertletTable.INSTANCE.get(call);
    }

    public static List<SqlOperator> knownOperators() {
        ArrayList<SqlOperator> retVal = new ArrayList<SqlOperator>(STANDARD_CONVERTLET_OPERATORS);
        for (DruidConvertletFactory convertletFactory : DRUID_CONVERTLET_FACTORIES) {
            retVal.addAll(convertletFactory.operators());
        }
        return retVal;
    }

    private static Map<SqlOperator, SqlRexConvertlet> createConvertletMap(PlannerContext plannerContext) {
        HashMap<SqlOperator, SqlRexConvertlet> table = new HashMap<SqlOperator, SqlRexConvertlet>();
        for (DruidConvertletFactory convertletFactory : DRUID_CONVERTLET_FACTORIES) {
            SqlRexConvertlet convertlet = convertletFactory.createConvertlet(plannerContext);
            for (SqlOperator operator : convertletFactory.operators()) {
                table.put(operator, convertlet);
            }
        }
        return table;
    }
}

