/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.druid.sql.calcite.view.DruidViewMacro;
import org.apache.druid.sql.calcite.view.ViewManager;

public class ViewSchema
extends AbstractSchema {
    private final ViewManager viewManager;

    @Inject
    public ViewSchema(ViewManager viewManager) {
        this.viewManager = (ViewManager)Preconditions.checkNotNull((Object)viewManager, (Object)"viewManager");
    }

    protected Multimap<String, Function> getFunctionMultimap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<String, DruidViewMacro> entry : this.viewManager.getViews().entrySet()) {
            builder.put(entry);
        }
        return builder.build();
    }
}

