/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.druid.sql.calcite.parser.DruidSqlIngest;
import org.apache.druid.sql.calcite.parser.SqlGranularityLiteral;
import org.apache.druid.sql.calcite.planner.DruidSqlIngestOperator;

public class DruidSqlInsert
extends DruidSqlIngest {
    public static final String SQL_INSERT_SEGMENT_GRANULARITY = "sqlInsertSegmentGranularity";
    public static final String SQL_INSERT_QUERY_GRANULARITY = "sqlInsertQueryGranularity";
    public static final SqlOperator OPERATOR = DruidSqlIngestOperator.INSERT_OPERATOR;

    public static DruidSqlInsert create(@Nonnull SqlInsert insertNode, @Nullable SqlGranularityLiteral partitionedBy, @Nullable SqlNodeList clusteredBy, @Nullable SqlIdentifier exportFileFormat) {
        return new DruidSqlInsert(insertNode.getParserPosition(), (SqlNodeList)insertNode.getOperandList().get(0), insertNode.getTargetTable(), insertNode.getSource(), insertNode.getTargetColumnList(), partitionedBy, clusteredBy, exportFileFormat);
    }

    public DruidSqlInsert(SqlParserPos pos, SqlNodeList keywords, SqlNode targetTable, SqlNode source, SqlNodeList columnList, @Nullable SqlGranularityLiteral partitionedBy, @Nullable SqlNodeList clusteredBy, @Nullable SqlIdentifier exportFileFormat) {
        super(pos, keywords, targetTable, source, columnList, partitionedBy, clusteredBy, exportFileFormat);
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep(this.isUpsert() ? "UPSERT INTO" : "INSERT INTO");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.getTargetTable().unparse(writer, opLeft, opRight);
        if (this.getTargetColumnList() != null) {
            this.getTargetColumnList().unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        if (this.getExportFileFormat() != null) {
            writer.keyword("AS");
            writer.print(this.getExportFileFormat().toString());
            writer.newlineAndIndent();
        }
        this.getSource().unparse(writer, 0, 0);
        writer.newlineAndIndent();
        if (this.getPartitionedBy() != null) {
            writer.keyword("PARTITIONED BY");
            this.getPartitionedBy().unparse(writer, leftPrec, rightPrec);
        }
        if (this.getClusteredBy() != null) {
            writer.keyword("CLUSTERED BY");
            SqlWriter.Frame frame = writer.startList("", "");
            for (SqlNode clusterByOpts : this.getClusteredBy().getList()) {
                clusterByOpts.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
        }
    }
}

