/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.security.AllowAllAuthorizer;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthValidator;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;

public class AuthorizerMapperModule
implements DruidModule {
    private static final String AUTHORIZER_PROPERTIES_FORMAT_STRING = "druid.auth.authorizer.%s";

    public void configure(Binder binder) {
        binder.bind(AuthorizerMapper.class).toProvider((Provider)new AuthorizerMapperProvider()).in(LazySingleton.class);
        binder.bind(AuthValidator.class).in(LazySingleton.class);
        LifecycleModule.register((Binder)binder, AuthorizerMapper.class);
    }

    private static void validateAuthorizers(List<String> authorizers) {
        if (authorizers == null) {
            return;
        }
        if (authorizers.isEmpty()) {
            throw new IAE("Must have at least one Authorizer configured.", new Object[0]);
        }
        HashSet<String> authorizerSet = new HashSet<String>();
        for (String authorizer : authorizers) {
            if (authorizerSet.contains(authorizer)) {
                throw new ISE("Cannot have multiple authorizers with the same name: [%s]", new Object[]{authorizer});
            }
            authorizerSet.add(authorizer);
        }
    }

    private static class AuthorizerMapperProvider
    implements Provider<AuthorizerMapper> {
        private AuthConfig authConfig;
        private Injector injector;
        private Properties props;
        private JsonConfigurator configurator;

        private AuthorizerMapperProvider() {
        }

        @Inject
        public void inject(Injector injector, Properties props, JsonConfigurator configurator) {
            this.authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
            this.injector = injector;
            this.props = props;
            this.configurator = configurator;
        }

        public AuthorizerMapper get() {
            final HashMap<String, Authorizer> authorizerMap = new HashMap<String, Authorizer>();
            List<String> authorizers = this.authConfig.getAuthorizers();
            AuthorizerMapperModule.validateAuthorizers(authorizers);
            if (authorizers == null) {
                final AllowAllAuthorizer allowAllAuthorizer = new AllowAllAuthorizer(null);
                authorizerMap.put("allowAll", allowAllAuthorizer);
                return new AuthorizerMapper(null){

                    @Override
                    public Authorizer getAuthorizer(String name) {
                        return allowAllAuthorizer;
                    }

                    @Override
                    public Map<String, Authorizer> getAuthorizerMap() {
                        return authorizerMap;
                    }
                };
            }
            for (String authorizerName : authorizers) {
                String authorizerPropertyBase = StringUtils.format((String)AuthorizerMapperModule.AUTHORIZER_PROPERTIES_FORMAT_STRING, (Object[])new Object[]{authorizerName});
                JsonConfigProvider authorizerProvider = JsonConfigProvider.of((String)authorizerPropertyBase, Authorizer.class);
                Properties adjustedProps = new Properties(this.props);
                String nameProperty = StringUtils.format((String)"druid.auth.authorizer.%s.name", (Object[])new Object[]{authorizerName});
                if (adjustedProps.containsKey(nameProperty)) {
                    throw new IAE("Name property [%s] is reserved.", new Object[]{nameProperty});
                }
                adjustedProps.put(nameProperty, authorizerName);
                authorizerProvider.inject(adjustedProps, this.configurator);
                Authorizer authorizer = (Authorizer)authorizerProvider.get();
                authorizerMap.put(authorizerName, authorizer);
            }
            return new AuthorizerMapper(authorizerMap);
        }
    }
}

