/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.http.AbstractHttpClientProvider;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.AbstractHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.security.Escalator;
import org.joda.time.Duration;

public class HttpClientModule
implements Module {
    private static final Set<Class<? extends Annotation>> ESCALATING_ANNOTATIONS = ImmutableSet.of(EscalatedGlobal.class, EscalatedClient.class);
    private final String propertyPrefix;
    private final Class<? extends Annotation> annotationClazz;
    private final boolean isEscalated;
    private final boolean eagerByDefault;

    public static HttpClientModule global() {
        return new HttpClientModule("druid.global.http", Global.class, false);
    }

    public static HttpClientModule escalatedGlobal() {
        return new HttpClientModule("druid.global.http", EscalatedGlobal.class, false);
    }

    public HttpClientModule(String propertyPrefix, Class<? extends Annotation> annotationClazz, boolean eagerByDefault) {
        this.propertyPrefix = (String)Preconditions.checkNotNull((Object)propertyPrefix, (Object)"propertyPrefix");
        this.annotationClazz = (Class)Preconditions.checkNotNull(annotationClazz, (Object)"annotationClazz");
        this.eagerByDefault = eagerByDefault;
        this.isEscalated = ESCALATING_ANNOTATIONS.contains(this.annotationClazz);
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, this.annotationClazz);
        binder.bind(HttpClient.class).annotatedWith(this.annotationClazz).toProvider((Provider)new HttpClientProvider(this.annotationClazz, this.isEscalated, this.eagerByDefault)).in(LazySingleton.class);
    }

    public static class HttpClientProvider
    extends AbstractHttpClientProvider<HttpClient> {
        private final boolean isEscalated;
        private final boolean eagerByDefault;
        private Escalator escalator;
        private DruidNode node;

        public HttpClientProvider(Class<? extends Annotation> annotationClazz, boolean isEscalated, boolean eagerByDefault) {
            super(annotationClazz);
            this.isEscalated = isEscalated;
            this.eagerByDefault = eagerByDefault;
        }

        @Inject
        public void inject(Escalator escalator, @Self DruidNode node) {
            this.escalator = escalator;
            this.node = node;
        }

        public HttpClient get() {
            DruidHttpClientConfig config = (DruidHttpClientConfig)((Supplier)this.getConfigProvider().get()).get();
            HttpClientConfig.Builder builder = HttpClientConfig.builder().withNumConnections(config.getNumConnections()).withEagerInitialization(config.isEagerInitialization(this.eagerByDefault)).withReadTimeout(config.getReadTimeout()).withWorkerCount(config.getNumMaxThreads()).withCompressionCodec(HttpClientConfig.CompressionCodec.valueOf((String)StringUtils.toUpperCase((String)config.getCompressionCodec()))).withUnusedConnectionTimeoutDuration(config.getUnusedConnectionTimeout());
            Binding<SSLContext> sslContextBinding = this.getSslContextBinding();
            if (sslContextBinding != null) {
                builder.withSslContext((SSLContext)sslContextBinding.getProvider().get());
            }
            final HttpClient client = HttpClientInit.createClient((HttpClientConfig)builder.build(), (Lifecycle)((Lifecycle)this.getLifecycleProvider().get()));
            AbstractHttpClient clientWithUserAgent = new AbstractHttpClient(){

                public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler, Duration readTimeout) {
                    request.setHeader("User-Agent", StringUtils.format((String)"%s/%s", (Object[])new Object[]{node.getServiceName(), node.getVersion()}));
                    return client.go(request, handler, readTimeout);
                }
            };
            if (this.isEscalated) {
                return this.escalator.createEscalatedClient((HttpClient)clientWithUserAgent);
            }
            return clientWithUserAgent;
        }
    }
}

