/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.InputFormatDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.utils.CollectionUtils;

public class InputFormats {

    public static class JsonFormatDefn
    extends BaseFormatDefn {
        public static final String TYPE_KEY = "json";

        public JsonFormatDefn() {
            super(null);
        }

        @Override
        public String typeValue() {
            return TYPE_KEY;
        }

        @Override
        protected Class<? extends InputFormat> inputFormatClass() {
            return JsonInputFormat.class;
        }

        @Override
        public InputFormat convertFromArgs(Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("type", TYPE_KEY);
            return this.convert(jsonMap, jsonMapper);
        }
    }

    public static class DelimitedFormatDefn
    extends FlatTextFormatDefn {
        public static final String TYPE_KEY = "tsv";
        public static final String DELIMITER_PARAMETER = "delimiter";
        @VisibleForTesting
        public static final String DELIMITER_FIELD = "delimiter";

        public DelimitedFormatDefn() {
            super(Collections.singletonList(new BaseTableFunction.Parameter("delimiter", TableFunction.ParameterType.VARCHAR, true)));
        }

        @Override
        public String typeValue() {
            return TYPE_KEY;
        }

        @Override
        protected Class<? extends InputFormat> inputFormatClass() {
            return DelimitedInputFormat.class;
        }

        @Override
        public InputFormat convertFromArgs(Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
            Map<String, Object> jsonMap = this.mapFromArgs(args, columns);
            jsonMap.put("type", TYPE_KEY);
            jsonMap.put("delimiter", CatalogUtils.getString(args, "delimiter"));
            return this.convert(jsonMap, jsonMapper);
        }
    }

    public static class CsvFormatDefn
    extends FlatTextFormatDefn {
        public static final String TYPE_KEY = "csv";

        public CsvFormatDefn() {
            super(null);
        }

        @Override
        public String typeValue() {
            return TYPE_KEY;
        }

        @Override
        protected Class<? extends InputFormat> inputFormatClass() {
            return CsvInputFormat.class;
        }

        @Override
        public InputFormat convertFromArgs(Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
            Map<String, Object> jsonMap = this.mapFromArgs(args, columns);
            jsonMap.put("type", TYPE_KEY);
            return this.convert(jsonMap, jsonMapper);
        }
    }

    public static abstract class FlatTextFormatDefn
    extends BaseFormatDefn {
        public static final String LIST_DELIMITER_PARAMETER = "listDelimiter";
        public static final String SKIP_ROWS_PARAMETER = "skipHeaderRows";
        private static final String COLUMNS_FIELD = "columns";
        private static final String FIND_COLUMNS_FIELD = "findColumnsFromHeader";
        private static final String SKIP_HEADERS_FIELD = "skipHeaderRows";
        private static final String LIST_DELIMITER_FIELD = "listDelimiter";

        public FlatTextFormatDefn(List<TableFunction.ParameterDefn> parameters) {
            super(CatalogUtils.concatLists(Arrays.asList(new BaseTableFunction.Parameter("listDelimiter", TableFunction.ParameterType.VARCHAR, true), new BaseTableFunction.Parameter("skipHeaderRows", TableFunction.ParameterType.BOOLEAN, true)), parameters));
        }

        @Override
        public void validate(ResolvedExternalTable table) {
            if (table.inputFormatMap == null) {
                return;
            }
            ResolvedTable resolvedTable = table.resolvedTable();
            Map<String, Object> jsonMap = this.toMap(table);
            jsonMap.putIfAbsent(COLUMNS_FIELD, Collections.singletonList("a"));
            this.convert(jsonMap, resolvedTable.jsonMapper());
        }

        protected Map<String, Object> toMap(ResolvedExternalTable table) {
            ResolvedTable resolvedTable = table.resolvedTable();
            HashMap<String, Object> jsonMap = new HashMap<String, Object>(table.inputFormatMap);
            if (!CollectionUtils.isNullOrEmpty(resolvedTable.spec().columns())) {
                this.convertColumns(jsonMap, resolvedTable.spec().columns());
            }
            this.adjustValues(jsonMap);
            return jsonMap;
        }

        protected void adjustValues(Map<String, Object> jsonMap) {
            jsonMap.put(FIND_COLUMNS_FIELD, false);
            jsonMap.computeIfAbsent("skipHeaderRows", key -> 0);
        }

        protected Map<String, Object> mapFromArgs(Map<String, Object> args, List<ColumnSpec> columns) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("listDelimiter", args.get("listDelimiter"));
            Object value = args.get("skipHeaderRows");
            jsonMap.put("skipHeaderRows", value == null ? Integer.valueOf(0) : value);
            this.convertColumns(jsonMap, columns);
            this.adjustValues(jsonMap);
            return jsonMap;
        }

        @Override
        public InputFormat convertFromTable(ResolvedExternalTable table) {
            return this.convert(this.toMap(table), table.resolvedTable().jsonMapper());
        }
    }

    public static abstract class BaseFormatDefn
    implements InputFormatDefn {
        private final List<TableFunction.ParameterDefn> parameters;

        public BaseFormatDefn(List<TableFunction.ParameterDefn> parameters) {
            this.parameters = parameters == null ? Collections.emptyList() : parameters;
        }

        @Override
        public List<TableFunction.ParameterDefn> parameters() {
            return this.parameters;
        }

        protected abstract Class<? extends InputFormat> inputFormatClass();

        @Override
        public void validate(ResolvedExternalTable table) {
            if (table.inputFormatMap != null) {
                this.convertFromTable(table);
            }
        }

        protected void convertColumns(Map<String, Object> jsonMap, List<ColumnSpec> columns) {
            List cols = columns.stream().map(col -> col.name()).collect(Collectors.toList());
            jsonMap.put("columns", cols);
        }

        public InputFormat convert(Map<String, Object> jsonMap, ObjectMapper jsonMapper) {
            try {
                return (InputFormat)jsonMapper.convertValue(jsonMap, this.inputFormatClass());
            }
            catch (Exception e) {
                throw new IAE((Throwable)e, "Invalid format specification", new Object[0]);
            }
        }

        @Override
        public InputFormat convertFromTable(ResolvedExternalTable table) {
            return this.convert(table.inputFormatMap, table.resolvedTable().jsonMapper());
        }
    }
}

