/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;

public abstract class AbstractHttpClientProvider<HttpClientType>
implements Provider<HttpClientType> {
    private final Key<Supplier<DruidHttpClientConfig>> configKey;
    private final Key<SSLContext> sslContextKey;
    private Injector injector;

    public AbstractHttpClientProvider(Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull(annotation, (Object)"annotation");
        this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){}, annotation);
        this.sslContextKey = Key.get(SSLContext.class, annotation);
    }

    @Inject
    public void configure(Injector injector) {
        this.injector = injector;
    }

    public Provider<Supplier<DruidHttpClientConfig>> getConfigProvider() {
        return this.injector.getProvider(this.configKey);
    }

    public Provider<Lifecycle> getLifecycleProvider() {
        return this.injector.getProvider(Lifecycle.class);
    }

    public Binding<SSLContext> getSslContextBinding() {
        return this.injector.getExistingBinding(this.sslContextKey);
    }
}

