/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.druid.concurrent.Threads;
import org.apache.druid.curator.CuratorConfig;
import org.apache.druid.curator.DruidConnectionStateListener;
import org.apache.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.AlertBuilder;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class CuratorModule
implements Module {
    private static final Logger log = new Logger(CuratorModule.class);
    static final int BASE_SLEEP_TIME_MS = 1000;
    static final int MAX_SLEEP_TIME_MS = 45000;
    private final boolean haltOnFailedStart;

    public CuratorModule() {
        this(true);
    }

    public CuratorModule(boolean haltOnFailedStart) {
        this.haltOnFailedStart = haltOnFailedStart;
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.zk.service", ZkEnablementConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.zk.service", CuratorConfig.class);
        MetricsModule.register(binder, DruidConnectionStateListener.class);
    }

    public static CuratorFramework createCurator(CuratorConfig config) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        if (!Strings.isNullOrEmpty((String)config.getZkUser()) && !Strings.isNullOrEmpty((String)config.getZkPwd())) {
            builder.authorization(config.getAuthScheme(), StringUtils.format((String)"%s:%s", (Object[])new Object[]{config.getZkUser(), config.getZkPwd()}).getBytes(StandardCharsets.UTF_8));
        }
        BoundedExponentialBackoffRetry retryPolicy = new BoundedExponentialBackoffRetry(1000, 45000, config.getMaxZkRetries());
        return builder.ensembleProvider((EnsembleProvider)new FixedEnsembleProvider(config.getZkHosts())).sessionTimeoutMs(config.getZkSessionTimeoutMs()).connectionTimeoutMs(config.getZkConnectionTimeoutMs()).retryPolicy((RetryPolicy)retryPolicy).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(config.getEnableCompression())).aclProvider((ACLProvider)(config.getEnableAcl() ? new SecuredACLProvider() : new DefaultACLProvider())).build();
    }

    @Provides
    @LazySingleton
    public CuratorFramework makeCurator(ZkEnablementConfig zkEnablementConfig, CuratorConfig config, DruidConnectionStateListener connectionStateListener, ServiceEmitter emitter, Lifecycle lifecycle) {
        if (!zkEnablementConfig.isEnabled()) {
            throw new RuntimeException("Zookeeper is disabled, cannot create CuratorFramework.");
        }
        CuratorFramework framework = CuratorModule.createCurator(config);
        framework.getConnectionStateListenable().addListener((Object)connectionStateListener);
        this.addUnhandledErrorListener(framework, emitter, lifecycle);
        this.addLifecycleHandler(framework, lifecycle);
        return framework;
    }

    @Provides
    @LazySingleton
    public DruidConnectionStateListener makeConnectionStateListener(ServiceEmitter emitter) {
        return new DruidConnectionStateListener(emitter);
    }

    private void addUnhandledErrorListener(CuratorFramework framework, ServiceEmitter emitter, Lifecycle lifecycle) {
        framework.getUnhandledErrorListenable().addListener((message, e) -> {
            emitter.emit((ServiceEventBuilder)AlertBuilder.create((String)"Unhandled Curator error", (Object[])new Object[0]).addThrowable(e));
            log.error(e, "Unhandled error in Curator, stopping server.", new Object[0]);
            if (this.haltOnFailedStart) {
                long startTime = System.currentTimeMillis();
                Thread halter = new Thread(() -> {
                    try {
                        Threads.sleepFor((long)30L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    log.warn("Could not stop server within %,d millis after unhandled Curator error. Halting immediately.", new Object[]{System.currentTimeMillis() - startTime});
                    Runtime.getRuntime().halt(1);
                }, "exiter-thread");
                halter.setDaemon(true);
                halter.start();
            }
            this.shutdown(lifecycle);
        });
    }

    private void addLifecycleHandler(final CuratorFramework framework, Lifecycle lifecycle) {
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() {
                log.debug("Starting Curator", new Object[0]);
                framework.start();
            }

            public void stop() {
                log.debug("Stopping Curator", new Object[0]);
                framework.close();
            }
        });
    }

    private void shutdown(Lifecycle lifecycle) {
        try {
            lifecycle.stop();
        }
        catch (Throwable t) {
            log.error(t, "Exception when stopping server after unhandled Curator error.", new Object[0]);
        }
        finally {
            System.exit(1);
        }
    }

    private static class SecuredACLProvider
    implements ACLProvider {
        private SecuredACLProvider() {
        }

        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

