/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.indexing;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.indexing.OverlordClient;

public class SpecificTaskServiceLocator
implements ServiceLocator {
    private static final String BASE_PATH = "/druid/worker/v1/chat";
    private static final long LOCATION_CACHE_MS = 30000L;
    private final String taskId;
    private final OverlordClient overlordClient;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private TaskState lastKnownState = TaskState.RUNNING;
    @GuardedBy(value="lock")
    private ServiceLocation lastKnownLocation;
    @GuardedBy(value="lock")
    private boolean closed = false;
    @GuardedBy(value="lock")
    private long lastUpdateTime = -1L;
    @GuardedBy(value="lock")
    private SettableFuture<ServiceLocations> pendingFuture = null;

    public SpecificTaskServiceLocator(String taskId, OverlordClient overlordClient) {
        this.taskId = taskId;
        this.overlordClient = overlordClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<ServiceLocations> locate() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingFuture != null) {
                return Futures.nonCancellationPropagating(this.pendingFuture);
            }
            if (this.closed || this.lastKnownState != TaskState.RUNNING) {
                return Futures.immediateFuture((Object)ServiceLocations.closed());
            }
            if (this.lastKnownLocation == null || this.lastUpdateTime + 30000L < System.currentTimeMillis()) {
                ListenableFuture<Map<String, TaskStatus>> taskStatusFuture;
                try {
                    taskStatusFuture = this.overlordClient.taskStatuses((Set<String>)ImmutableSet.of((Object)this.taskId));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                SettableFuture retVal = this.pendingFuture = SettableFuture.create();
                this.pendingFuture.addListener(() -> {
                    if (!taskStatusFuture.isDone()) {
                        taskStatusFuture.cancel(true);
                    }
                }, (Executor)Execs.directExecutor());
                Futures.addCallback(taskStatusFuture, (FutureCallback)new FutureCallback<Map<String, TaskStatus>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(Map<String, TaskStatus> taskStatusMap) {
                        Object object = SpecificTaskServiceLocator.this.lock;
                        synchronized (object) {
                            if (SpecificTaskServiceLocator.this.pendingFuture != null) {
                                SpecificTaskServiceLocator.this.lastUpdateTime = System.currentTimeMillis();
                                TaskStatus status = taskStatusMap.get(SpecificTaskServiceLocator.this.taskId);
                                if (status == null) {
                                    SpecificTaskServiceLocator.this.resolvePendingFuture(null, null);
                                } else if (TaskLocation.unknown().equals((Object)status.getLocation())) {
                                    SpecificTaskServiceLocator.this.fetchFallbackTaskLocation();
                                } else {
                                    SpecificTaskServiceLocator.this.resolvePendingFuture(status.getStatusCode(), status.getLocation());
                                }
                            }
                        }
                    }

                    public void onFailure(Throwable t) {
                        SpecificTaskServiceLocator.this.resolvePendingFutureOnException(t);
                    }
                }, (Executor)Execs.directExecutor());
                return Futures.nonCancellationPropagating((ListenableFuture)retVal);
            }
            return Futures.immediateFuture((Object)ServiceLocations.forLocation(this.lastKnownLocation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                if (this.pendingFuture != null) {
                    this.pendingFuture.set((Object)ServiceLocations.closed());
                    this.pendingFuture = null;
                }
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolvePendingFuture(TaskState state, TaskLocation location) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingFuture != null) {
                this.lastKnownState = state;
                ServiceLocation serviceLocation = this.lastKnownLocation = location == null ? null : new ServiceLocation(location.getHost(), location.getPort(), location.getTlsPort(), StringUtils.format((String)"%s/%s", (Object[])new Object[]{BASE_PATH, StringUtils.urlEncode((String)this.taskId)}));
                if (this.lastKnownState != TaskState.RUNNING) {
                    this.pendingFuture.set((Object)ServiceLocations.closed());
                } else if (this.lastKnownLocation == null) {
                    this.pendingFuture.set((Object)ServiceLocations.forLocations(Collections.emptySet()));
                } else {
                    this.pendingFuture.set((Object)ServiceLocations.forLocation(this.lastKnownLocation));
                }
                this.pendingFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolvePendingFutureOnException(Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingFuture != null) {
                this.pendingFuture.setException(t);
                this.pendingFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFallbackTaskLocation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingFuture != null) {
                ListenableFuture<TaskStatusResponse> taskStatusFuture;
                try {
                    taskStatusFuture = this.overlordClient.taskStatus(this.taskId);
                }
                catch (Exception e) {
                    this.resolvePendingFutureOnException(e);
                    return;
                }
                this.pendingFuture.addListener(() -> {
                    if (!taskStatusFuture.isDone()) {
                        taskStatusFuture.cancel(true);
                    }
                }, (Executor)Execs.directExecutor());
                Futures.addCallback(taskStatusFuture, (FutureCallback)new FutureCallback<TaskStatusResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(TaskStatusResponse taskStatusResponse) {
                        Object object = SpecificTaskServiceLocator.this.lock;
                        synchronized (object) {
                            if (SpecificTaskServiceLocator.this.pendingFuture != null) {
                                SpecificTaskServiceLocator.this.lastUpdateTime = System.currentTimeMillis();
                                TaskStatusPlus status = taskStatusResponse.getStatus();
                                if (status == null) {
                                    SpecificTaskServiceLocator.this.resolvePendingFuture(null, null);
                                } else if (TaskLocation.unknown().equals((Object)status.getLocation())) {
                                    SpecificTaskServiceLocator.this.resolvePendingFuture(status.getStatusCode(), null);
                                } else {
                                    SpecificTaskServiceLocator.this.resolvePendingFuture(status.getStatusCode(), status.getLocation());
                                }
                            }
                        }
                    }

                    public void onFailure(Throwable t) {
                        SpecificTaskServiceLocator.this.resolvePendingFutureOnException(t);
                    }
                }, (Executor)Execs.directExecutor());
            }
        }
    }
}

