/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SegmentsMetadataManagerProvider;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaCache;

public class SqlSegmentsMetadataManagerProvider
implements SegmentsMetadataManagerProvider {
    private final ObjectMapper jsonMapper;
    private final Supplier<SegmentsMetadataManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> storageConfig;
    private final SQLMetadataConnector connector;
    private final Lifecycle lifecycle;
    private final ServiceEmitter serviceEmitter;
    private final SegmentSchemaCache segmentSchemaCache;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;

    @Inject
    public SqlSegmentsMetadataManagerProvider(ObjectMapper jsonMapper, Supplier<SegmentsMetadataManagerConfig> config, Supplier<MetadataStorageTablesConfig> storageConfig, SQLMetadataConnector connector, Lifecycle lifecycle, SegmentSchemaCache segmentSchemaCache, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig, ServiceEmitter serviceEmitter) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.storageConfig = storageConfig;
        this.connector = connector;
        this.lifecycle = lifecycle;
        this.serviceEmitter = serviceEmitter;
        this.segmentSchemaCache = segmentSchemaCache;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
    }

    @Override
    public SegmentsMetadataManager get() {
        this.lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() {
                SqlSegmentsMetadataManagerProvider.this.connector.createSegmentSchemasTable();
                SqlSegmentsMetadataManagerProvider.this.connector.createSegmentTable();
                SqlSegmentsMetadataManagerProvider.this.connector.createUpgradeSegmentsTable();
            }

            public void stop() {
            }
        });
        return new SqlSegmentsMetadataManager(this.jsonMapper, this.config, this.storageConfig, this.connector, this.segmentSchemaCache, this.centralizedDatasourceSchemaConfig, this.serviceEmitter);
    }
}

