/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;

public class ExpressionMultiValueDimensionSelector
implements DimensionSelector {
    protected final ColumnValueSelector<ExprEval> baseSelector;

    public static ExpressionMultiValueDimensionSelector fromValueSelector(ColumnValueSelector<ExprEval> baseSelector, @Nullable ExtractionFn extractionFn) {
        if (extractionFn != null) {
            return new ExtractionMultiValueDimensionSelector(baseSelector, extractionFn);
        }
        return new ExpressionMultiValueDimensionSelector(baseSelector);
    }

    public ExpressionMultiValueDimensionSelector(ColumnValueSelector<ExprEval> baseSelector) {
        this.baseSelector = baseSelector;
    }

    ExprEval getEvaluated() {
        return (ExprEval)this.baseSelector.getObject();
    }

    @Nullable
    String getValue(ExprEval evaluated) {
        assert (!evaluated.isArray());
        return evaluated.asString();
    }

    @Nullable
    List<String> getArrayAsList(ExprEval evaluated) {
        assert (evaluated.isArray());
        if (evaluated.asArray() == null) {
            return null;
        }
        return Arrays.stream(evaluated.asArray()).map(Evals::asString).collect(Collectors.toList());
    }

    @Nullable
    String getArrayValue(ExprEval evaluated, int i) {
        return ExpressionMultiValueDimensionSelector.getArrayElement(evaluated, i);
    }

    @Override
    public IndexedInts getRow() {
        ExprEval evaluated = this.getEvaluated();
        if (evaluated.isArray()) {
            RangeIndexedInts ints = new RangeIndexedInts();
            Object[] evaluatedArray = evaluated.asArray();
            ints.setSize(evaluatedArray != null ? evaluatedArray.length : 0);
            return ints;
        }
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        ExprEval evaluated = this.getEvaluated();
        if (evaluated.isArray()) {
            return this.getArrayValue(evaluated, id);
        }
        assert (id == 0);
        return evaluated.asString();
    }

    @Override
    public ValueMatcher makeValueMatcher(final @Nullable String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                ExprEval evaluated = ExpressionMultiValueDimensionSelector.this.getEvaluated();
                if (evaluated.isArray()) {
                    List<String> array = ExpressionMultiValueDimensionSelector.this.getArrayAsList(evaluated);
                    if (array == null) {
                        return includeUnknown || value == null;
                    }
                    return array.stream().anyMatch(x -> includeUnknown && x == null || Objects.equals(x, value));
                }
                String rowValue = ExpressionMultiValueDimensionSelector.this.getValue(evaluated);
                return includeUnknown && rowValue == null || Objects.equals(rowValue, value);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", ExpressionMultiValueDimensionSelector.this.baseSelector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final DruidPredicateFactory predicateFactory) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                ExprEval evaluated = ExpressionMultiValueDimensionSelector.this.getEvaluated();
                DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
                if (evaluated.isArray()) {
                    List<String> array = ExpressionMultiValueDimensionSelector.this.getArrayAsList(evaluated);
                    if (array == null) {
                        return predicate.apply(null).matches(includeUnknown);
                    }
                    return array.stream().anyMatch(x -> predicate.apply((String)x).matches(includeUnknown));
                }
                String rowValue = ExpressionMultiValueDimensionSelector.this.getValue(evaluated);
                return predicate.apply(rowValue).matches(includeUnknown);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", ExpressionMultiValueDimensionSelector.this.baseSelector);
                inspector.visit("predicate", predicateFactory);
            }
        };
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("baseSelector", this.baseSelector);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        ExprEval evaluated = this.getEvaluated();
        if (evaluated.isArray()) {
            return this.getArrayAsList(evaluated);
        }
        return this.getValue(evaluated);
    }

    @Override
    public Class<?> classOfObject() {
        return Object.class;
    }

    @Nullable
    private static String getArrayElement(ExprEval eval, int i) {
        Object[] stringArray = eval.asArray();
        if (stringArray == null) {
            return null;
        }
        return Evals.asString(stringArray[i]);
    }

    static class ExtractionMultiValueDimensionSelector
    extends ExpressionMultiValueDimensionSelector {
        private final ExtractionFn extractionFn;

        private ExtractionMultiValueDimensionSelector(ColumnValueSelector<ExprEval> baseSelector, ExtractionFn extractionFn) {
            super(baseSelector);
            this.extractionFn = extractionFn;
        }

        @Override
        String getValue(ExprEval evaluated) {
            assert (!evaluated.isArray());
            return this.extractionFn.apply(evaluated.asString());
        }

        @Override
        List<String> getArrayAsList(ExprEval evaluated) {
            assert (evaluated.isArray());
            return Arrays.stream(evaluated.asArray()).map(x -> this.extractionFn.apply(Evals.asString(x))).collect(Collectors.toList());
        }

        @Override
        String getArrayValue(ExprEval evaluated, int i) {
            return this.extractionFn.apply(ExpressionMultiValueDimensionSelector.getArrayElement(evaluated, i));
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseSelector", this.baseSelector);
            inspector.visit("extractionFn", this.extractionFn);
        }
    }
}

