/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.CompressedBlockSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class CompressedLongsSerializer
implements Serializer {
    private final CompressedBlockSerializer blockSerializer;
    private final ByteBuffer longValueConverter = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder());

    public CompressedLongsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, CompressionStrategy compression, Closer closer) {
        this.blockSerializer = new CompressedBlockSerializer(segmentWriteOutMedium, compression, 65536, closer);
    }

    public void open() throws IOException {
        this.blockSerializer.open();
    }

    public void add(long value) throws IOException {
        this.longValueConverter.clear();
        this.longValueConverter.putLong(value);
        this.longValueConverter.rewind();
        this.blockSerializer.addValue(this.longValueConverter);
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.blockSerializer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        this.blockSerializer.writeTo(channel, fileBuilder);
    }
}

