/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnValueSwapper;
import org.apache.druid.query.rowsandcols.column.VectorCopier;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.apache.druid.segment.column.ColumnType;

public class ConstantObjectColumn
implements Column {
    private final Object obj;
    private final int numRows;
    private final ColumnType type;

    public ConstantObjectColumn(Object obj, int numRows, ColumnType type) {
        this.obj = obj;
        this.numRows = numRows;
        this.type = type;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        return new ConstantColumnAccessor();
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        if (VectorCopier.class.equals(clazz)) {
            return (T)((VectorCopier)(into, intoStart) -> {
                if (Integer.MAX_VALUE - this.numRows < intoStart) {
                    throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.CAPACITY_EXCEEDED).build("too many rows!!! intoStart[%,d], vals.length[%,d] combine to exceed max_int", intoStart, this.numRows);
                }
                Arrays.fill(into, intoStart, intoStart + this.numRows, this.obj);
            });
        }
        if (ColumnValueSwapper.class.equals(clazz)) {
            return (T)((ColumnValueSwapper)(lhs, rhs) -> {});
        }
        return null;
    }

    private class ConstantColumnAccessor
    implements BinarySearchableAccessor {
        private ConstantColumnAccessor() {
        }

        @Override
        public ColumnType getType() {
            return ConstantObjectColumn.this.type;
        }

        @Override
        public int numRows() {
            return ConstantObjectColumn.this.numRows;
        }

        @Override
        public boolean isNull(int rowNum) {
            return ConstantObjectColumn.this.obj == null;
        }

        @Override
        public Object getObject(int rowNum) {
            return ConstantObjectColumn.this.obj;
        }

        @Override
        public double getDouble(int rowNum) {
            return ((Number)ConstantObjectColumn.this.obj).doubleValue();
        }

        @Override
        public float getFloat(int rowNum) {
            return ((Number)ConstantObjectColumn.this.obj).floatValue();
        }

        @Override
        public long getLong(int rowNum) {
            return ((Number)ConstantObjectColumn.this.obj).longValue();
        }

        @Override
        public int getInt(int rowNum) {
            return ((Number)ConstantObjectColumn.this.obj).intValue();
        }

        @Override
        public int compareRows(int lhsRowNum, int rhsRowNum) {
            return 0;
        }

        @Override
        public FindResult findNull(int startIndex, int endIndex) {
            return this.findComplex(startIndex, endIndex, null);
        }

        @Override
        public FindResult findDouble(int startIndex, int endIndex, double val) {
            return this.findComplex(startIndex, endIndex, val);
        }

        @Override
        public FindResult findFloat(int startIndex, int endIndex, float val) {
            return this.findComplex(startIndex, endIndex, Float.valueOf(val));
        }

        @Override
        public FindResult findLong(int startIndex, int endIndex, long val) {
            return this.findComplex(startIndex, endIndex, val);
        }

        @Override
        public FindResult findString(int startIndex, int endIndex, String val) {
            return this.findComplex(startIndex, endIndex, val);
        }

        @Override
        public FindResult findComplex(int startIndex, int endIndex, Object val) {
            boolean same = ConstantObjectColumn.this.obj == null ? val == null : ConstantObjectColumn.this.obj.equals(val);
            return same ? FindResult.found(startIndex, endIndex) : FindResult.notFound(endIndex);
        }
    }
}

