/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.value.ShiftedColumnAccessorBase;
import org.apache.druid.query.operator.window.value.WindowValueProcessorBase;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;

public class WindowOffsetProcessor
extends WindowValueProcessorBase {
    private final int offset;

    @JsonCreator
    public WindowOffsetProcessor(@JsonProperty(value="inputColumn") String inputColumn, @JsonProperty(value="outputColumn") String outputColumn, @JsonProperty(value="offset") int offset) {
        super(inputColumn, outputColumn);
        this.offset = offset;
    }

    @JsonProperty(value="offset")
    public int getOffset() {
        return this.offset;
    }

    @Override
    public RowsAndColumns process(RowsAndColumns input) {
        final int numRows = input.numRows();
        return this.processInternal(input, column -> new ColumnAccessorBasedColumn(new ShiftedColumnAccessorBase(column.toAccessor()){

            @Override
            protected int getActualValue(int rowNum) {
                return rowNum + WindowOffsetProcessor.this.offset;
            }

            @Override
            protected boolean outsideBounds(int rowNum) {
                return rowNum < 0 || rowNum >= numRows;
            }
        }));
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        if (otherProcessor instanceof WindowOffsetProcessor) {
            WindowOffsetProcessor other = (WindowOffsetProcessor)otherProcessor;
            return this.offset == other.offset && this.intervalValidation(other);
        }
        return false;
    }

    @Override
    public String toString() {
        return "WindowOffsetProcessor{" + this.internalToString() + ", offset=" + this.offset + "}";
    }
}

