/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.systemfield;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFieldInputSource;
import org.apache.druid.segment.transform.RowFunction;
import org.apache.druid.segment.transform.TransformedInputRow;

public class SystemFieldDecoratorFactory {
    public static final SystemFieldDecoratorFactory NONE = new SystemFieldDecoratorFactory((entity, field) -> null, EnumSet.noneOf(SystemField.class));
    private final BiFunction<InputEntity, SystemField, Object> extractor;
    private final Set<SystemField> fields;

    SystemFieldDecoratorFactory(BiFunction<InputEntity, SystemField, Object> extractor, Set<SystemField> fields) {
        this.extractor = extractor;
        this.fields = fields;
    }

    public static SystemFieldDecoratorFactory fromInputSource(SystemFieldInputSource source) {
        return new SystemFieldDecoratorFactory(source::getSystemFieldValue, source.getConfiguredSystemFields());
    }

    public Function<InputRow, InputRow> decorator(InputEntity entity) {
        if (this.fields.isEmpty()) {
            return Function.identity();
        }
        HashMap<String, ConstantRowFunction> transforms = new HashMap<String, ConstantRowFunction>();
        for (SystemField field : this.fields) {
            Object fieldValue = this.extractor.apply(entity, field);
            transforms.put(field.toString(), new ConstantRowFunction(fieldValue));
        }
        return row -> new TransformedInputRow((InputRow)row, (Map<String, RowFunction>)transforms);
    }

    private static class ConstantRowFunction
    implements RowFunction {
        private final Object value;

        public ConstantRowFunction(Object value) {
            this.value = value;
        }

        @Override
        public Object eval(Row row) {
            return this.value;
        }

        @Override
        public List<String> evalDimension(Row row) {
            return Collections.singletonList(this.value == null ? null : String.valueOf(this.value));
        }
    }
}

