/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.FastLineIterator;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.CloseableIteratorWithMetadata;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.ParserUtils;
import org.apache.druid.segment.column.RowSignature;

public abstract class TextReader<T>
extends IntermediateRowParsingReader<T> {
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;

    protected TextReader(InputRowSchema inputRowSchema, InputEntity source) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
    }

    public InputRowSchema getInputRowSchema() {
        return this.inputRowSchema;
    }

    @Override
    public CloseableIteratorWithMetadata<T> intermediateRowIteratorWithMetadata() throws IOException {
        final CloseableIterator<T> delegate = this.makeSourceIterator(this.source.open());
        final int numHeaderLines = this.getNumHeaderLinesToSkip();
        for (int i = 0; i < numHeaderLines && delegate.hasNext(); ++i) {
            delegate.next();
        }
        if (this.needsToProcessHeaderLine() && delegate.hasNext()) {
            this.processHeaderLine(delegate.next());
        }
        return new CloseableIteratorWithMetadata<T>(){
            private static final String LINE_KEY = "Line";
            private long currentLineNumber;
            {
                this.currentLineNumber = numHeaderLines + (TextReader.this.needsToProcessHeaderLine() ? 1 : 0);
            }

            @Override
            public Map<String, Object> currentMetadata() {
                return Collections.singletonMap(LINE_KEY, this.currentLineNumber);
            }

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                ++this.currentLineNumber;
                return delegate.next();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    protected InputEntity source() {
        return this.source;
    }

    @Override
    public abstract List<InputRow> parseInputRows(T var1) throws IOException, ParseException;

    public abstract int getNumHeaderLinesToSkip();

    public abstract boolean needsToProcessHeaderLine();

    public abstract void processHeaderLine(T var1) throws IOException;

    protected abstract CloseableIterator<T> makeSourceIterator(InputStream var1);

    public static RowSignature findOrCreateInputRowSignature(List<String> parsedLine) {
        ArrayList<String> columns = new ArrayList<String>(parsedLine.size());
        for (int i = 0; i < parsedLine.size(); ++i) {
            if (com.google.common.base.Strings.isNullOrEmpty((String)parsedLine.get(i))) {
                columns.add(ParserUtils.getDefaultColumnName(i));
                continue;
            }
            columns.add(parsedLine.get(i));
        }
        ParserUtils.validateFields(columns);
        RowSignature.Builder builder = RowSignature.builder();
        for (String column : columns) {
            builder.add(column, null);
        }
        return builder.build();
    }

    public static abstract class Bytes
    extends TextReader<byte[]> {
        protected Bytes(InputRowSchema inputRowSchema, InputEntity source) {
            super(inputRowSchema, source);
        }

        @Override
        protected CloseableIterator<byte[]> makeSourceIterator(InputStream in) {
            return new FastLineIterator.Bytes(in);
        }

        @Override
        protected String intermediateRowAsString(@Nullable byte[] row) {
            return row == null ? "null" : StringUtils.fromUtf8(row);
        }
    }

    public static abstract class Strings
    extends TextReader<String> {
        protected Strings(InputRowSchema inputRowSchema, InputEntity source) {
            super(inputRowSchema, source);
        }

        @Override
        protected CloseableIterator<String> makeSourceIterator(InputStream in) {
            return new FastLineIterator.Strings(in);
        }
    }
}

