/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.segment.data.Indexed;

public class SortedValueDictionary
implements Closeable {
    private final Indexed<String> sortedStrings;
    private final Indexed<Long> sortedLongs;
    private final Indexed<Double> sortedDoubles;
    private final Indexed<Object[]> sortedArrays;
    @Nullable
    private final Closeable closeable;

    public SortedValueDictionary(Indexed<String> sortedStrings, Indexed<Long> sortedLongs, Indexed<Double> sortedDoubles, Indexed<Object[]> sortedArrays, @Nullable Closeable closeable) {
        this.sortedStrings = sortedStrings;
        this.sortedLongs = sortedLongs;
        this.sortedDoubles = sortedDoubles;
        this.sortedArrays = sortedArrays;
        this.closeable = closeable;
    }

    public Indexed<String> getSortedStrings() {
        return this.sortedStrings;
    }

    public Indexed<Long> getSortedLongs() {
        return this.sortedLongs;
    }

    public Indexed<Double> getSortedDoubles() {
        return this.sortedDoubles;
    }

    public Indexed<Object[]> getSortedArrays() {
        return this.sortedArrays;
    }

    public int getStringCardinality() {
        return this.sortedStrings.size();
    }

    public int getLongCardinality() {
        return this.sortedLongs.size();
    }

    public int getDoubleCardinality() {
        return this.sortedDoubles.size();
    }

    public int getArrayCardinality() {
        return this.sortedArrays.size();
    }

    public boolean allNull() {
        for (String s : this.sortedStrings) {
            if (s == null) continue;
            return false;
        }
        if (this.sortedLongs.size() > 0) {
            return false;
        }
        if (this.sortedDoubles.size() > 0) {
            return false;
        }
        return this.sortedArrays.size() == 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

