/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataColumnV3;
import org.apache.druid.segment.nested.NestedDataColumnV4;
import org.apache.druid.segment.nested.NestedDataColumnV5;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.ComplexColumnMetadata;

public class NestedDataColumnSupplierV4
implements Supplier<ComplexColumn> {
    private final byte version;
    private final String columnName;
    private final ColumnConfig columnConfig;
    private final GenericIndexed<ByteBuffer> fields;
    private final FieldTypeInfo fieldInfo;
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final SmooshedFileMapper fileMapper;
    @Nullable
    private final ColumnType simpleType;
    private final ColumnType logicalType;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final ByteOrder byteOrder;

    public static NestedDataColumnSupplierV4 read(ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, ObjectMapper jsonMapper) {
        return NestedDataColumnSupplierV4.read(bb, columnBuilder, columnConfig, jsonMapper, ColumnType.LONG.getStrategy(), ColumnType.DOUBLE.getStrategy());
    }

    public static NestedDataColumnSupplierV4 read(ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, ObjectMapper jsonMapper, TypeStrategy<Long> longTypeStrategy, TypeStrategy<Double> doubleTypeStrategy) {
        byte version = bb.get();
        if (version == 3 || version == 4 || version == 5) {
            try {
                ImmutableBitmap nullValues;
                Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
                SmooshedFileMapper mapper = columnBuilder.getFileMapper();
                ComplexColumnMetadata metadata = (ComplexColumnMetadata)jsonMapper.readValue(IndexMerger.SERIALIZER_UTILS.readString(bb), ComplexColumnMetadata.class);
                GenericIndexed<ByteBuffer> fields = GenericIndexed.read(bb, GenericIndexed.UTF8_STRATEGY, mapper);
                FieldTypeInfo fieldInfo = FieldTypeInfo.read(bb, fields.size());
                ColumnType simpleType = fields.size() == 0 ? ColumnType.STRING : (fields.size() == 1 && (version == 3 && ".".equals(StringUtils.fromUtf8((ByteBuffer)fields.get(0))) || (version == 4 || version == 5) && "$".equals(StringUtils.fromUtf8((ByteBuffer)fields.get(0)))) ? fieldInfo.getTypes(0).getSingleType() : null);
                ByteBuffer stringDictionaryBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__stringDictionary");
                Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier = StringEncodingStrategies.getStringDictionarySupplier(mapper, stringDictionaryBuffer, metadata.getByteOrder());
                ByteBuffer longDictionaryBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__longDictionary");
                Supplier<FixedIndexed<Long>> longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, longTypeStrategy, metadata.getByteOrder(), 8);
                ByteBuffer doubleDictionaryBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__doubleDictionary");
                Supplier<FixedIndexed<Double>> doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, doubleTypeStrategy, metadata.getByteOrder(), 8);
                if (version == 5) {
                    ByteBuffer arrayDictionarybuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__arrayDictionary");
                    arrayDictionarySupplier = FrontCodedIntArrayIndexed.read(arrayDictionarybuffer, metadata.getByteOrder());
                } else {
                    arrayDictionarySupplier = null;
                }
                ByteBuffer rawBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__raw");
                CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer(ColumnSerializerUtils.getInternalFileName(metadata.getFileNameBase(), "__raw"), rawBuffer, metadata.getByteOrder(), metadata.getByteOrder(), mapper);
                if (metadata.hasNulls().booleanValue()) {
                    columnBuilder.setHasNulls(true);
                    ByteBuffer nullIndexBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__nullIndex");
                    nullValues = metadata.getBitmapSerdeFactory().getObjectStrategy().fromByteBufferWithSize(nullIndexBuffer);
                } else {
                    nullValues = metadata.getBitmapSerdeFactory().getBitmapFactory().makeEmptyImmutableBitmap();
                }
                return new NestedDataColumnSupplierV4(version, metadata.getFileNameBase(), columnConfig, fields, fieldInfo, compressedRawColumnSupplier, nullValues, stringDictionarySupplier, longDictionarySupplier, doubleDictionarySupplier, arrayDictionarySupplier, mapper, metadata.getBitmapSerdeFactory(), metadata.getByteOrder(), simpleType);
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    private NestedDataColumnSupplierV4(byte version, String columnName, ColumnConfig columnConfig, GenericIndexed<ByteBuffer> fields, FieldTypeInfo fieldInfo, CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier, ImmutableBitmap nullValues, Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, SmooshedFileMapper fileMapper, BitmapSerdeFactory bitmapSerdeFactory, ByteOrder byteOrder, @Nullable ColumnType simpleType) {
        this.version = version;
        this.columnName = columnName;
        this.columnConfig = columnConfig;
        this.fields = fields;
        this.fieldInfo = fieldInfo;
        this.compressedRawColumnSupplier = compressedRawColumnSupplier;
        this.nullValues = nullValues;
        this.stringDictionarySupplier = stringDictionarySupplier;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.fileMapper = fileMapper;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.byteOrder = byteOrder;
        this.simpleType = simpleType;
        this.logicalType = simpleType == null ? ColumnType.NESTED_DATA : simpleType;
    }

    public ComplexColumn get() {
        if (this.version == 3) {
            return this.makeV3();
        }
        if (this.version == 4) {
            return this.makeV4();
        }
        return this.makeV5();
    }

    @Nullable
    public ColumnType getSimpleType() {
        return this.simpleType;
    }

    private NestedDataColumnV3 makeV3() {
        return new NestedDataColumnV3<Indexed<ByteBuffer>>(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.stringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
    }

    private NestedDataColumnV4 makeV4() {
        return new NestedDataColumnV4<Indexed<ByteBuffer>>(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.stringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
    }

    private NestedDataColumnV5 makeV5() {
        return new NestedDataColumnV5(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields::singleThreaded, this.fieldInfo, this.stringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.arrayDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
    }

    private static ByteBuffer loadInternalFile(SmooshedFileMapper fileMapper, ComplexColumnMetadata metadata, String internalFileName) throws IOException {
        return fileMapper.mapFile(ColumnSerializerUtils.getInternalFileName(metadata.getFileNameBase(), internalFileName));
    }
}

