/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.vector.VectorCursor;

public interface CursorHolder
extends Closeable {
    @Nullable
    public Cursor asCursor();

    @Nullable
    default public VectorCursor asVectorCursor() {
        throw new UOE("Cannot vectorize. Check 'canVectorize' before calling 'makeVectorCursor' on %s.", this.getClass().getName());
    }

    default public boolean canVectorize() {
        return false;
    }

    default public boolean isPreAggregated() {
        return false;
    }

    @Nullable
    default public List<AggregatorFactory> getAggregatorsForPreAggregated() {
        return null;
    }

    default public List<OrderBy> getOrdering() {
        return Collections.emptyList();
    }

    default public Order getTimeOrder() {
        List<OrderBy> ordering = this.getOrdering();
        if (!ordering.isEmpty() && "__time".equals(ordering.get(0).getColumnName())) {
            return ordering.get(0).getOrder();
        }
        return Order.NONE;
    }

    @Override
    default public void close() {
    }
}

