/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.HashPartitioner;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public class HashBasedNumberedShardSpec
extends NumberedShardSpec {
    public static final List<String> DEFAULT_PARTITION_DIMENSIONS = ImmutableList.of();
    private final int bucketId;
    private final int numBuckets;
    private final ObjectMapper jsonMapper;
    private final List<String> partitionDimensions;
    @Nullable
    private final HashPartitionFunction partitionFunction;

    @JsonCreator
    public HashBasedNumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions, @JsonProperty(value="bucketId") @Nullable Integer bucketId, @JsonProperty(value="numBuckets") @Nullable Integer numBuckets, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JsonProperty(value="partitionFunction") @Nullable HashPartitionFunction partitionFunction, @JacksonInject ObjectMapper jsonMapper) {
        super(partitionNum, partitions);
        this.bucketId = bucketId == null ? partitionNum : bucketId;
        this.numBuckets = numBuckets == null ? partitions : numBuckets;
        this.partitionDimensions = partitionDimensions == null ? DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
        this.partitionFunction = partitionFunction;
        this.jsonMapper = jsonMapper;
    }

    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty(value="partitionDimensions")
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @JsonProperty
    @Nullable
    public HashPartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    @Override
    public List<String> getDomainDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        if (this.partitionFunction == null) {
            throw new ISE("Cannot create a hashPartitioner since partitionFunction is null", new Object[0]);
        }
        return new HashPartitioner(this.jsonMapper, this.partitionFunction, this.partitionDimensions, this.numBuckets).createHashLookup(shardSpecs);
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        if (this.partitionFunction == null) {
            return true;
        }
        if (this.partitionDimensions.isEmpty()) {
            return true;
        }
        HashMap<String, Set<String>> domainSet = new HashMap<String, Set<String>>();
        for (String p : this.partitionDimensions) {
            RangeSet<String> domainRangeSet = domain.get(p);
            if (domainRangeSet == null || domainRangeSet.isEmpty()) {
                return true;
            }
            for (Range v : domainRangeSet.asRanges()) {
                if (v.isEmpty() || !v.hasLowerBound() || !v.hasUpperBound() || v.lowerBoundType() != BoundType.CLOSED || v.upperBoundType() != BoundType.CLOSED || !((String)((Object)v.lowerEndpoint())).equals(v.upperEndpoint())) {
                    return true;
                }
                domainSet.computeIfAbsent(p, k -> new HashSet()).add((String)((Object)v.lowerEndpoint()));
            }
        }
        return !domainSet.isEmpty() && this.chunkPossibleInDomain(this.partitionFunction, domainSet, new HashMap<String, String>());
    }

    private boolean chunkPossibleInDomain(HashPartitionFunction hashPartitionFunction, Map<String, Set<String>> domainSet, Map<String, String> partitionDimensionsValues) {
        int curIndex = partitionDimensionsValues.size();
        if (curIndex == this.partitionDimensions.size()) {
            return this.isInChunk(hashPartitionFunction, partitionDimensionsValues);
        }
        String dimension = this.partitionDimensions.get(curIndex);
        for (String e : domainSet.get(dimension)) {
            partitionDimensionsValues.put(dimension, e);
            if (this.chunkPossibleInDomain(hashPartitionFunction, domainSet, partitionDimensionsValues)) {
                return true;
            }
            partitionDimensionsValues.remove(dimension);
        }
        return false;
    }

    private boolean isInChunk(HashPartitionFunction hashPartitionFunction, Map<String, String> partitionDimensionsValues) {
        assert (!this.partitionDimensions.isEmpty());
        List groupKey = Lists.transform(this.partitionDimensions, o -> Collections.singletonList((String)partitionDimensionsValues.get(o)));
        return hashPartitionFunction.hash(HashBasedNumberedShardSpec.serializeGroupKey(this.jsonMapper, groupKey), this.numBuckets) == this.bucketId;
    }

    public static byte[] serializeGroupKey(ObjectMapper jsonMapper, List<Object> partitionKeys) {
        try {
            return jsonMapper.writeValueAsBytes(partitionKeys);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getType() {
        return "hashed";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HashBasedNumberedShardSpec that = (HashBasedNumberedShardSpec)o;
        return this.bucketId == that.bucketId && this.numBuckets == that.numBuckets && Objects.equals(this.partitionDimensions, that.partitionDimensions) && this.partitionFunction == that.partitionFunction;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.bucketId, this.numBuckets, this.partitionDimensions, this.partitionFunction});
    }

    @Override
    public String toString() {
        return "HashBasedNumberedShardSpec{bucketId=" + this.bucketId + ", numBuckets=" + this.numBuckets + ", partitionDimensions=" + this.partitionDimensions + ", partitionFunction=" + this.partitionFunction + "}";
    }
}

