/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.IndexedInts;

public class RangeIndexedInts
implements IndexedInts {
    private int size;

    public void setSize(int size) {
        if (size < 0) {
            throw new IAE("Size[%d] must be non-negative", size);
        }
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IAE("index[%d] >= size[%d] or < 0", index, this.size);
        }
        return index;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

