/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.lookup.LookupExtractor;

@JsonTypeName(value="map")
public class MapLookupExtractor
extends LookupExtractor {
    private static final long HEAP_ENTRY_OVERHEAD = 80L;
    private final Map<String, String> map;
    private final boolean isOneToOne;

    @JsonCreator
    public MapLookupExtractor(@JsonProperty(value="map") Map<String, String> map, @JsonProperty(value="isOneToOne") boolean isOneToOne) {
        this.map = (Map)Preconditions.checkNotNull(map, (Object)"map");
        this.isOneToOne = isOneToOne;
    }

    public static <K, V> long estimateHeapFootprint(Iterable<Map.Entry<K, V>> entries) {
        int numEntries = 0;
        long numChars = 0L;
        for (Map.Entry<K, V> sEntry : entries) {
            K key = sEntry.getKey();
            V value = sEntry.getValue();
            ++numEntries;
            if (key instanceof String) {
                numChars += (long)((String)key).length();
            }
            if (!(value instanceof String)) continue;
            numChars += (long)((String)value).length();
        }
        return 80L * (long)numEntries + numChars * 2L;
    }

    @JsonProperty
    public Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.map);
    }

    @Override
    @Nullable
    public String apply(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.map.get(key);
    }

    @Override
    public List<String> unapply(@Nullable String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Iterator<String> unapplyAll(Set<String> values) {
        return Iterators.transform((Iterator)Iterators.filter(this.map.entrySet().iterator(), entry -> {
            if (entry.getKey() == null) {
                return false;
            }
            return values.contains(entry.getValue());
        }), Map.Entry::getKey);
    }

    @Override
    @JsonProperty(value="isOneToOne")
    public boolean isOneToOne() {
        return this.isOneToOne;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!Strings.isNullOrEmpty((String)key)) {
                    outputStream.write(StringUtils.toUtf8(key));
                }
                outputStream.write(-1);
                if (!Strings.isNullOrEmpty((String)val)) {
                    outputStream.write(StringUtils.toUtf8(val));
                }
                outputStream.write(-1);
            }
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean supportsAsMap() {
        return true;
    }

    @Override
    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public long estimateHeapFootprint() {
        return MapLookupExtractor.estimateHeapFootprint(this.map.entrySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLookupExtractor that = (MapLookupExtractor)o;
        return this.isOneToOne == that.isOneToOne && this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.isOneToOne, this.map);
    }
}

