/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;

public class ExpressionDruidPredicateFactory
implements DruidPredicateFactory {
    private final Expr expr;
    private final ColumnCapabilities inputCapabilites;

    public ExpressionDruidPredicateFactory(Expr expr, ColumnCapabilities inputCapabilites) {
        this.expr = expr;
        this.inputCapabilites = inputCapabilites;
    }

    @Override
    public DruidObjectPredicate<String> makeStringPredicate() {
        return value -> {
            ExprEval eval = this.expr.eval(InputBindings.forInputSupplier(ExpressionType.STRING, () -> value));
            if (eval.value() == null) {
                return DruidPredicateMatch.UNKNOWN;
            }
            return DruidPredicateMatch.of(eval.asBoolean());
        };
    }

    @Override
    public DruidLongPredicate makeLongPredicate() {
        return new DruidLongPredicate(){

            @Override
            public DruidPredicateMatch applyLong(long input) {
                ExprEval eval = ExpressionDruidPredicateFactory.this.expr.eval(InputBindings.forInputSupplier(ExpressionType.LONG, () -> input));
                if (eval.isNumericNull()) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                return DruidPredicateMatch.of(eval.asBoolean());
            }

            @Override
            public DruidPredicateMatch applyNull() {
                ExprEval eval = ExpressionDruidPredicateFactory.this.expr.eval(InputBindings.nilBindings());
                if (eval.isNumericNull()) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                return DruidPredicateMatch.of(eval.asBoolean());
            }
        };
    }

    @Override
    public DruidFloatPredicate makeFloatPredicate() {
        return new DruidFloatPredicate(){

            @Override
            public DruidPredicateMatch applyFloat(float input) {
                ExprEval eval = ExpressionDruidPredicateFactory.this.expr.eval(InputBindings.forInputSupplier(ExpressionType.DOUBLE, () -> Float.valueOf(input)));
                if (eval.isNumericNull()) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                return DruidPredicateMatch.of(eval.asBoolean());
            }

            @Override
            public DruidPredicateMatch applyNull() {
                ExprEval eval = ExpressionDruidPredicateFactory.this.expr.eval(InputBindings.nilBindings());
                if (eval.isNumericNull()) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                return DruidPredicateMatch.of(eval.asBoolean());
            }
        };
    }

    @Override
    public DruidDoublePredicate makeDoublePredicate() {
        return new DruidDoublePredicate(){

            @Override
            public DruidPredicateMatch applyDouble(double input) {
                ExprEval eval = ExpressionDruidPredicateFactory.this.expr.eval(InputBindings.forInputSupplier(ExpressionType.DOUBLE, () -> input));
                if (eval.isNumericNull()) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                return DruidPredicateMatch.of(eval.asBoolean());
            }

            @Override
            public DruidPredicateMatch applyNull() {
                ExprEval eval = ExpressionDruidPredicateFactory.this.expr.eval(InputBindings.nilBindings());
                if (eval.isNumericNull()) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                return DruidPredicateMatch.of(eval.asBoolean());
            }
        };
    }

    @Override
    public DruidObjectPredicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> arrayType) {
        if (this.inputCapabilites == null) {
            return input -> {
                ExprEval eval = this.expr.eval(InputBindings.forInputSupplier(ExpressionType.STRING_ARRAY, () -> input));
                if (eval.value() == null) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                return DruidPredicateMatch.of(eval.asBoolean());
            };
        }
        return input -> {
            ExprEval eval = this.expr.eval(InputBindings.forInputSupplier(ExpressionType.fromColumnType(this.inputCapabilites), () -> input));
            if (eval.value() == null) {
                return DruidPredicateMatch.UNKNOWN;
            }
            return DruidPredicateMatch.of(eval.asBoolean());
        };
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

