/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;

public class LifecycleForkJoinPoolProvider {
    private static final Logger LOG = new Logger(LifecycleForkJoinPoolProvider.class);
    private final long awaitShutdownMillis;
    private final ForkJoinPool pool;

    public LifecycleForkJoinPoolProvider(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode, long awaitShutdownMillis) {
        this.pool = new ForkJoinPool(parallelism, factory, handler, asyncMode);
        this.awaitShutdownMillis = awaitShutdownMillis;
    }

    @LifecycleStop
    public void stop() {
        LOG.info("Shutting down ForkJoinPool [%s]", this);
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(this.awaitShutdownMillis, TimeUnit.MILLISECONDS)) {
                LOG.warn("Failed to complete all tasks in FJP [%s]", this);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted on shutdown", e);
        }
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }
}

