/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.UnnestCursorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class UnnestColumnValueSelectorCursor
implements Cursor {
    private final Cursor baseCursor;
    private final ColumnSelectorFactory baseColumnSelectorFactory;
    private final ColumnValueSelector columnValueSelector;
    private final VirtualColumn unnestColumn;
    private final String outputName;
    private int index;
    private Object currentVal;
    private @MonotonicNonNull List<Object> unnestListForCurrentRow;
    private boolean needInitialization;

    public UnnestColumnValueSelectorCursor(Cursor cursor, ColumnSelectorFactory baseColumnSelectorFactory, VirtualColumn unnestColumn, String outputColumnName) {
        this.baseCursor = cursor;
        this.baseColumnSelectorFactory = baseColumnSelectorFactory;
        this.columnValueSelector = unnestColumn.makeColumnValueSelector(unnestColumn.getOutputName(), this.baseColumnSelectorFactory);
        this.unnestColumn = unnestColumn;
        this.index = 0;
        this.outputName = outputColumnName;
        this.needInitialization = true;
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return new ColumnSelectorFactory(){

            @Override
            public DimensionSelector makeDimensionSelector(final DimensionSpec dimensionSpec) {
                if (!UnnestColumnValueSelectorCursor.this.outputName.equals(dimensionSpec.getDimension())) {
                    return UnnestColumnValueSelectorCursor.this.baseColumnSelectorFactory.makeDimensionSelector(dimensionSpec);
                }
                return new BaseSingleValueDimensionSelector(){
                    final ColumnValueSelector colSelector;
                    {
                        this.colSelector = this.makeColumnValueSelector(dimensionSpec.getDimension());
                    }

                    @Override
                    @Nullable
                    protected String getValue() {
                        Object returnedObj = this.colSelector.getObject();
                        if (returnedObj == null) {
                            return null;
                        }
                        return String.valueOf(returnedObj);
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        this.colSelector.inspectRuntimeShape(inspector);
                    }
                };
            }

            @Override
            public ColumnValueSelector makeColumnValueSelector(String columnName) {
                if (!UnnestColumnValueSelectorCursor.this.outputName.equals(columnName)) {
                    return UnnestColumnValueSelectorCursor.this.baseColumnSelectorFactory.makeColumnValueSelector(columnName);
                }
                return new ColumnValueSelector(){

                    @Override
                    public double getDouble() {
                        Object value = this.getObject();
                        if (value == null) {
                            return 0.0;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).doubleValue();
                        }
                        throw new UOE("Cannot convert object to double", new Object[0]);
                    }

                    @Override
                    public float getFloat() {
                        Object value = this.getObject();
                        if (value == null) {
                            return 0.0f;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).floatValue();
                        }
                        throw new UOE("Cannot convert object to float", new Object[0]);
                    }

                    @Override
                    public long getLong() {
                        Object value = this.getObject();
                        if (value == null) {
                            return 0L;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).longValue();
                        }
                        throw new UOE("Cannot convert object to long", new Object[0]);
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        UnnestColumnValueSelectorCursor.this.columnValueSelector.inspectRuntimeShape(inspector);
                    }

                    @Override
                    public boolean isNull() {
                        return this.getObject() == null;
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        return UnnestColumnValueSelectorCursor.this.unnestListForCurrentRow.get(UnnestColumnValueSelectorCursor.this.index);
                    }

                    @Override
                    public Class<?> classOfObject() {
                        return Object.class;
                    }
                };
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (UnnestColumnValueSelectorCursor.this.outputName.equals(column)) {
                    return UnnestCursorFactory.computeOutputColumnCapabilities(UnnestColumnValueSelectorCursor.this.baseColumnSelectorFactory, UnnestColumnValueSelectorCursor.this.unnestColumn);
                }
                return UnnestColumnValueSelectorCursor.this.baseColumnSelectorFactory.getColumnCapabilities(column);
            }
        };
    }

    @Override
    public void advance() {
        this.advanceUninterruptibly();
        BaseQuery.checkInterrupted();
    }

    @Override
    public void advanceUninterruptibly() {
        this.advanceAndUpdate();
    }

    @Override
    public boolean isDone() {
        if (this.needInitialization && !this.baseCursor.isDone()) {
            this.initialize();
        }
        return this.baseCursor.isDone();
    }

    @Override
    public boolean isDoneOrInterrupted() {
        if (this.needInitialization && !this.baseCursor.isDoneOrInterrupted()) {
            this.initialize();
        }
        return this.baseCursor.isDoneOrInterrupted();
    }

    @Override
    public void reset() {
        this.index = 0;
        this.needInitialization = true;
        this.baseCursor.reset();
    }

    private void getNextRow() {
        this.currentVal = this.columnValueSelector.getObject();
        this.unnestListForCurrentRow = this.currentVal == null ? Collections.emptyList() : (this.currentVal instanceof List ? (List<Object>)this.currentVal : (this.currentVal instanceof Object[] ? Arrays.asList((Object[])this.currentVal) : Collections.singletonList(this.currentVal)));
    }

    private void initialize() {
        this.getNextRow();
        if (this.unnestListForCurrentRow.isEmpty()) {
            this.moveToNextNonEmptyRow();
        }
        this.needInitialization = false;
    }

    private void moveToNextNonEmptyRow() {
        this.index = 0;
        do {
            this.baseCursor.advance();
            if (this.baseCursor.isDone()) {
                return;
            }
            this.getNextRow();
        } while (this.unnestListForCurrentRow.isEmpty());
    }

    private void advanceAndUpdate() {
        if (++this.index >= this.unnestListForCurrentRow.size()) {
            this.moveToNextNonEmptyRow();
        }
    }
}

