/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;

class ColumnSignature {
    private final String name;
    @Nullable
    private final ColumnType type;

    @JsonCreator
    ColumnSignature(@JsonProperty(value="name") String name, @JsonProperty(value="type") @Nullable ColumnType type) {
        this.name = name;
        this.type = type;
        if (name == null || name.isEmpty()) {
            throw new IAE("Column name must be provided and non-empty", new Object[0]);
        }
    }

    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    ColumnType type() {
        return this.type;
    }

    public String toString() {
        return "ColumnSignature{name='" + this.name + "', type=" + String.valueOf(this.type) + "}";
    }
}

