/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.NvlFunctionVectorProcessor;

public final class NvlVectorObjectProcessor
extends NvlFunctionVectorProcessor<Object[]> {
    private final Object[] output;

    public NvlVectorObjectProcessor(ExpressionType outputType, ExprVectorProcessor<Object[]> inputProcessor, ExprVectorProcessor<Object[]> elseProcessor) {
        super(outputType, inputProcessor, elseProcessor);
        this.output = new Object[inputProcessor.maxVectorSize()];
    }

    @Override
    public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding bindings) {
        this.inputBindingFilterer.setBindings(bindings);
        ExprEvalVector inputVector = this.inputProcessor.evalVector(bindings);
        Object[] inputValues = inputVector.getObjectVector();
        int[] selection = this.inputBindingFilterer.getVectorMatch().getSelection();
        int nulls = 0;
        for (int i = 0; i < bindings.getCurrentVectorSize(); ++i) {
            if (inputValues[i] == null) {
                selection[nulls++] = i;
                continue;
            }
            this.output[i] = inputValues[i];
        }
        this.inputBindingFilterer.getVectorMatch().setSelectionSize(nulls);
        ExprEvalVector elseVector = this.elseProcessor.evalVector(this.inputBindingFilterer);
        Object[] elseValues = elseVector.getObjectVector();
        for (int i = 0; i < nulls; ++i) {
            this.output[selection[i]] = elseValues[i];
        }
        return new ExprEvalObjectVector(this.output, this.outputType);
    }
}

