/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantExprEvalSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.virtual.ExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.ExpressionMultiValueDimensionSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSingleValueDimensionSelector;
import org.apache.druid.segment.virtual.RowBasedExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleLongInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputDimensionSelector;

public class ExpressionSelectors {
    private ExpressionSelectors() {
    }

    public static ColumnValueSelector makeColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return baseSelector.getDouble();
            }

            @Override
            public float getFloat() {
                return baseSelector.getFloat();
            }

            @Override
            public long getLong() {
                return baseSelector.getLong();
            }

            @Override
            public boolean isNull() {
                return baseSelector.isNull();
            }

            @Override
            @Nullable
            public Object getObject() {
                ExprEval eval = (ExprEval)baseSelector.getObject();
                return ExpressionSelectors.coerceEvalToSelectorObject(eval);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        };
    }

    public static ColumnValueSelector<ExprEval> makeExprEvalSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        return ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, ExpressionPlanner.plan(columnSelectorFactory, expression));
    }

    public static ColumnValueSelector<ExprEval> makeExprEvalSelector(ColumnSelectorFactory columnSelectorFactory, ExpressionPlan plan) {
        Expr.ObjectBinding bindings;
        if (plan.is(ExpressionPlan.Trait.SINGLE_INPUT_SCALAR)) {
            String column = plan.getSingleInputName();
            ValueType inputType = plan.getSingleInputType();
            if (inputType == ValueType.LONG) {
                return new SingleLongInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeColumnValueSelector(column), plan.getExpression(), !"__time".equals(column));
            }
            if (inputType == ValueType.STRING) {
                return new SingleStringInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), plan.getExpression());
            }
        }
        if ((bindings = ExpressionSelectors.createBindings(plan.getAnalysis(), columnSelectorFactory)).equals(ExprUtils.nilBindings())) {
            return new ConstantExprEvalSelector(plan.getExpression().eval(bindings));
        }
        if (plan.is(ExpressionPlan.Trait.UNKNOWN_INPUTS)) {
            return new RowBasedExpressionColumnValueSelector(plan, bindings);
        }
        return new ExpressionColumnValueSelector(plan.getAppliedExpression(), bindings);
    }

    public static DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, @Nullable ExtractionFn extractionFn) {
        ColumnValueSelector<ExprEval> baseSelector;
        ExpressionPlan plan = ExpressionPlanner.plan(columnSelectorFactory, expression);
        if (plan.is(ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE)) {
            String column = plan.getSingleInputName();
            if (plan.getSingleInputType() == ValueType.STRING) {
                return new SingleStringInputDimensionSelector(columnSelectorFactory.makeDimensionSelector(DefaultDimensionSpec.of(column)), expression);
            }
        }
        if ((baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression)) instanceof ConstantExprEvalSelector) {
            return DimensionSelector.constant(((ExprEval)baseSelector.getObject()).asString(), extractionFn);
        }
        if (baseSelector instanceof NilColumnValueSelector) {
            return DimensionSelector.constant(null);
        }
        if (plan.any(ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.UNKNOWN_INPUTS)) {
            return ExpressionMultiValueDimensionSelector.fromValueSelector(baseSelector, extractionFn);
        }
        return ExpressionSingleValueDimensionSelector.fromValueSelector(baseSelector, extractionFn);
    }

    public static boolean canMapOverDictionary(Expr.BindingAnalysis bindingAnalysis, ColumnCapabilities.Capable hasMultipleValues) {
        Preconditions.checkState((bindingAnalysis.getRequiredBindings().size() == 1 ? 1 : 0) != 0, (Object)"requiredBindings.size == 1");
        return !hasMultipleValues.isUnknown() && !bindingAnalysis.hasInputArrays() && !bindingAnalysis.isOutputArray();
    }

    private static Expr.ObjectBinding createBindings(Expr.BindingAnalysis bindingAnalysis, ColumnSelectorFactory columnSelectorFactory) {
        HashMap suppliers = new HashMap();
        List columns = bindingAnalysis.getRequiredBindingsList();
        for (String columnName : columns) {
            Object supplier;
            ColumnValueSelector selector;
            boolean multiVal;
            ColumnCapabilities columnCapabilities = columnSelectorFactory.getColumnCapabilities(columnName);
            ValueType nativeType = columnCapabilities != null ? columnCapabilities.getType() : null;
            boolean bl = multiVal = columnCapabilities != null && columnCapabilities.hasMultipleValues().isTrue();
            if (nativeType == ValueType.FLOAT) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getFloat);
            } else if (nativeType == ValueType.LONG) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getLong);
            } else if (nativeType == ValueType.DOUBLE) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getDouble);
            } else {
                supplier = nativeType == ValueType.STRING ? ExpressionSelectors.supplierFromDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName)), multiVal) : (nativeType == null ? ExpressionSelectors.supplierFromObjectSelector(columnSelectorFactory.makeColumnValueSelector(columnName)) : null);
            }
            if (supplier == null) continue;
            suppliers.put(columnName, (Supplier)supplier);
        }
        if (suppliers.isEmpty()) {
            return ExprUtils.nilBindings();
        }
        if (suppliers.size() == 1 && columns.size() == 1) {
            String column = (String)Iterables.getOnlyElement(suppliers.keySet());
            Supplier supplier = (Supplier)Iterables.getOnlyElement(suppliers.values());
            return identifierName -> {
                assert (column.equals(identifierName));
                return supplier.get();
            };
        }
        return Parser.withSuppliers(suppliers);
    }

    private static <T> Supplier<T> makeNullableNumericSupplier(ColumnValueSelector selector, Supplier<T> supplier) {
        if (NullHandling.replaceWithDefault()) {
            return supplier;
        }
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return supplier.get();
        };
    }

    @VisibleForTesting
    static Supplier<Object> supplierFromDimensionSelector(DimensionSelector selector, boolean coerceArray) {
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return () -> {
            IndexedInts row = selector.getRow();
            if (row.size() == 1 && !coerceArray) {
                return selector.lookupName(row.get(0));
            }
            if (row.size() == 0) {
                return new String[]{null};
            }
            String[] strings = new String[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                strings[i] = selector.lookupName(row.get(i));
            }
            return strings;
        };
    }

    @Nullable
    static Supplier<Object> supplierFromObjectSelector(BaseObjectColumnValueSelector<?> selector) {
        Class<Object> clazz;
        block7: {
            block6: {
                if (selector instanceof NilColumnValueSelector) {
                    return null;
                }
                clazz = selector.classOfObject();
                if (Number.class.isAssignableFrom(clazz)) break block6;
                if (!String.class.isAssignableFrom(clazz)) break block7;
            }
            return selector::getObject;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val instanceof Number || val instanceof String) {
                    return val;
                }
                if (val instanceof List) {
                    return ExpressionSelectors.coerceListToArray((List)val);
                }
                return null;
            };
        }
        if (clazz.isAssignableFrom(List.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val != null) {
                    return ExpressionSelectors.coerceListToArray((List)val);
                }
                return null;
            };
        }
        return null;
    }

    public static Object coerceListToArray(@Nullable List<?> val) {
        if (val != null && val.size() > 0) {
            Class coercedType = null;
            for (Object elem : val) {
                if (elem == null) continue;
                coercedType = ExpressionSelectors.convertType(coercedType, elem.getClass());
            }
            if (coercedType == Long.class || coercedType == Integer.class) {
                return val.stream().map(x -> x != null ? Long.valueOf(((Number)x).longValue()) : null).toArray(Long[]::new);
            }
            if (coercedType == Float.class || coercedType == Double.class) {
                return val.stream().map(x -> x != null ? Double.valueOf(((Number)x).doubleValue()) : null).toArray(Double[]::new);
            }
            return val.stream().map(x -> x != null ? x.toString() : null).toArray(String[]::new);
        }
        return new String[]{null};
    }

    private static Class convertType(@Nullable Class existing, Class next) {
        if (Number.class.isAssignableFrom(next) || next == String.class) {
            if (existing == null) {
                return next;
            }
            if (existing == String.class) {
                return existing;
            }
            if (next == String.class) {
                return next;
            }
            if (existing == Integer.class) {
                return next;
            }
            if (existing == Float.class) {
                if (next == Double.class) {
                    return next;
                }
                return existing;
            }
            if (existing == Long.class) {
                if (next == Integer.class) {
                    return existing;
                }
                return next;
            }
            return Double.class;
        }
        throw new UOE("Invalid array expression type: %s", new Object[]{next});
    }

    @Nullable
    public static Object coerceEvalToSelectorObject(ExprEval eval) {
        switch (eval.type()) {
            case STRING_ARRAY: {
                return Arrays.stream(eval.asStringArray()).collect(Collectors.toList());
            }
            case DOUBLE_ARRAY: {
                return Arrays.stream(eval.asDoubleArray()).collect(Collectors.toList());
            }
            case LONG_ARRAY: {
                return Arrays.stream(eval.asLongArray()).collect(Collectors.toList());
            }
        }
        return eval.value();
    }
}

