/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.column.SimpleColumnHolder;
import org.apache.druid.segment.column.SpatialIndex;
import org.apache.druid.segment.column.ValueType;

public class ColumnBuilder {
    private final ColumnCapabilitiesImpl capabilitiesBuilder = ColumnCapabilitiesImpl.createDefault();
    @Nullable
    private Supplier<? extends BaseColumn> columnSupplier = null;
    @Nullable
    private Supplier<BitmapIndex> bitmapIndex = null;
    @Nullable
    private Supplier<SpatialIndex> spatialIndex = null;
    @Nullable
    private SmooshedFileMapper fileMapper = null;

    public ColumnBuilder setFileMapper(SmooshedFileMapper fileMapper) {
        this.fileMapper = fileMapper;
        return this;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    public ColumnBuilder setType(ValueType type) {
        this.capabilitiesBuilder.setType(type);
        return this;
    }

    public ColumnBuilder setHasMultipleValues(boolean hasMultipleValues) {
        this.capabilitiesBuilder.setHasMultipleValues(hasMultipleValues);
        return this;
    }

    public ColumnBuilder setDictionaryEncodedColumnSupplier(Supplier<? extends DictionaryEncodedColumn<?>> columnSupplier) {
        this.columnSupplier = columnSupplier;
        this.capabilitiesBuilder.setDictionaryEncoded(true);
        this.capabilitiesBuilder.setDictionaryValuesSorted(true);
        this.capabilitiesBuilder.setDictionaryValuesUnique(true);
        return this;
    }

    public ColumnBuilder setFilterable(boolean filterable) {
        this.capabilitiesBuilder.setFilterable(filterable);
        return this;
    }

    public ColumnBuilder setComplexColumnSupplier(Supplier<? extends ComplexColumn> columnSupplier) {
        this.columnSupplier = columnSupplier;
        return this;
    }

    public ColumnBuilder setNumericColumnSupplier(Supplier<? extends NumericColumn> columnSupplier) {
        this.columnSupplier = columnSupplier;
        return this;
    }

    public ColumnBuilder setBitmapIndex(Supplier<BitmapIndex> bitmapIndex) {
        this.bitmapIndex = bitmapIndex;
        this.capabilitiesBuilder.setHasBitmapIndexes(true);
        return this;
    }

    public ColumnBuilder setSpatialIndex(Supplier<SpatialIndex> spatialIndex) {
        this.spatialIndex = spatialIndex;
        this.capabilitiesBuilder.setHasSpatialIndexes(true);
        return this;
    }

    public ColumnBuilder setHasNulls(boolean nullable) {
        this.capabilitiesBuilder.setHasNulls(nullable);
        return this;
    }

    public ColumnBuilder setHasNulls(ColumnCapabilities.Capable nullable) {
        this.capabilitiesBuilder.setHasNulls(nullable);
        return this;
    }

    public ColumnHolder build() {
        Preconditions.checkState((this.capabilitiesBuilder.getType() != null ? 1 : 0) != 0, (Object)"Type must be set.");
        return new SimpleColumnHolder(this.capabilitiesBuilder, this.columnSupplier, this.bitmapIndex, this.spatialIndex);
    }
}

