/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.AbstractPrioritizedCallable;
import org.apache.druid.query.ConcatQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.metadata.SegmentAnalyzer;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.Segment;
import org.joda.time.Interval;

public class SegmentMetadataQueryRunnerFactory
implements QueryRunnerFactory<SegmentAnalysis, SegmentMetadataQuery> {
    private static final Logger log = new Logger(SegmentMetadataQueryRunnerFactory.class);
    private final SegmentMetadataQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SegmentMetadataQueryRunnerFactory(SegmentMetadataQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<SegmentAnalysis> createRunner(final Segment segment) {
        return new QueryRunner<SegmentAnalysis>(){

            @Override
            public Sequence<SegmentAnalysis> run(QueryPlus<SegmentAnalysis> inQ, ResponseContext responseContext) {
                Granularity queryGranularity;
                TimestampSpec timestampSpec;
                HashMap<String, AggregatorFactory> aggregators;
                SegmentMetadataQuery updatedQuery = ((SegmentMetadataQuery)inQ.getQuery()).withFinalizedAnalysisTypes(SegmentMetadataQueryRunnerFactory.this.toolChest.getConfig());
                SegmentAnalyzer analyzer = new SegmentAnalyzer(updatedQuery.getAnalysisTypes());
                Map<String, ColumnAnalysis> analyzedColumns = analyzer.analyze(segment);
                long numRows = analyzer.numRows(segment);
                long totalSize = 0L;
                if (analyzer.analyzingSize()) {
                    totalSize = (long)analyzedColumns.size() * numRows;
                }
                TreeMap<String, ColumnAnalysis> columns = new TreeMap<String, ColumnAnalysis>();
                ColumnIncluderator includerator = updatedQuery.getToInclude();
                for (Map.Entry<String, ColumnAnalysis> entry : analyzedColumns.entrySet()) {
                    String columnName = entry.getKey();
                    AggregatorFactory[] column = entry.getValue();
                    if (!column.isError()) {
                        totalSize += column.getSize();
                    }
                    if (!includerator.include(columnName)) continue;
                    columns.put(columnName, (ColumnAnalysis)column);
                }
                List<Interval> retIntervals = updatedQuery.analyzingInterval() ? Collections.singletonList(segment.getDataInterval()) : null;
                Metadata metadata = null;
                if (updatedQuery.hasAggregators()) {
                    metadata = segment.asStorageAdapter().getMetadata();
                    if (metadata != null && metadata.getAggregators() != null) {
                        aggregators = new HashMap<String, AggregatorFactory>();
                        for (AggregatorFactory aggregator : metadata.getAggregators()) {
                            aggregators.put(aggregator.getName(), aggregator);
                        }
                    } else {
                        aggregators = null;
                    }
                } else {
                    aggregators = null;
                }
                if (updatedQuery.hasTimestampSpec()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    timestampSpec = metadata != null ? metadata.getTimestampSpec() : null;
                } else {
                    timestampSpec = null;
                }
                if (updatedQuery.hasQueryGranularity()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    queryGranularity = metadata != null ? metadata.getQueryGranularity() : null;
                } else {
                    queryGranularity = null;
                }
                Boolean rollup = null;
                if (updatedQuery.hasRollup()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    Boolean bl = rollup = metadata != null ? metadata.isRollup() : null;
                    if (rollup == null) {
                        rollup = Boolean.TRUE;
                    }
                }
                return Sequences.simple(Collections.singletonList(new SegmentAnalysis(segment.getId().toString(), retIntervals, columns, totalSize, numRows, aggregators, timestampSpec, queryGranularity, rollup)));
            }
        };
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeRunners(ExecutorService exec, Iterable<QueryRunner<SegmentAnalysis>> queryRunners) {
        final ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)exec);
        return new ConcatQueryRunner<SegmentAnalysis>(Sequences.map((Sequence)Sequences.simple(queryRunners), (Function)new Function<QueryRunner<SegmentAnalysis>, QueryRunner<SegmentAnalysis>>(){

            public QueryRunner<SegmentAnalysis> apply(final QueryRunner<SegmentAnalysis> input) {
                return new QueryRunner<SegmentAnalysis>(){

                    @Override
                    public Sequence<SegmentAnalysis> run(QueryPlus<SegmentAnalysis> queryPlus, final ResponseContext responseContext) {
                        Query<SegmentAnalysis> query = queryPlus.getQuery();
                        int priority = QueryContexts.getPriority(query);
                        final QueryPlus<SegmentAnalysis> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
                        ListenableFuture future = queryExecutor.submit((Callable)new AbstractPrioritizedCallable<Sequence<SegmentAnalysis>>(priority){

                            @Override
                            public Sequence<SegmentAnalysis> call() {
                                return Sequences.simple((Iterable)input.run(threadSafeQueryPlus, responseContext).toList());
                            }
                        });
                        try {
                            SegmentMetadataQueryRunnerFactory.this.queryWatcher.registerQueryFuture(query, future);
                            if (QueryContexts.hasTimeout(query)) {
                                return (Sequence)future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
                            }
                            return (Sequence)future.get();
                        }
                        catch (InterruptedException e) {
                            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
                            future.cancel(true);
                            throw new QueryInterruptedException(e);
                        }
                        catch (CancellationException e) {
                            throw new QueryInterruptedException(e);
                        }
                        catch (TimeoutException e) {
                            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
                            future.cancel(true);
                            throw new QueryInterruptedException(e);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        }));
    }

    @Override
    public QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> getToolchest() {
        return this.toolChest;
    }
}

