/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.Filters;

public class AndDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private static final Joiner AND_JOINER = Joiner.on((String)" && ");
    private final List<DimFilter> fields;

    @JsonCreator
    public AndDimFilter(@JsonProperty(value="fields") List<DimFilter> fields) {
        fields = DimFilters.filterNulls(fields);
        Preconditions.checkArgument((fields.size() > 0 ? 1 : 0) != 0, (Object)"AND operator requires at least one field");
        this.fields = fields;
    }

    public AndDimFilter(DimFilter ... fields) {
        this(Arrays.asList(fields));
    }

    @JsonProperty
    public List<DimFilter> getFields() {
        return this.fields;
    }

    public byte[] getCacheKey() {
        return DimFilterUtils.computeCacheKey((byte)1, this.fields);
    }

    @Override
    public DimFilter optimize() {
        List<DimFilter> elements = DimFilters.optimize(this.fields).stream().filter(filter -> !(filter instanceof TrueDimFilter)).collect(Collectors.toList());
        if (elements.isEmpty()) {
            return TrueDimFilter.instance();
        }
        if (elements.size() == 1) {
            return (DimFilter)elements.get(0);
        }
        if (elements.stream().anyMatch(filter -> filter instanceof FalseDimFilter)) {
            return FalseDimFilter.instance();
        }
        return new AndDimFilter(elements);
    }

    @Override
    public Filter toFilter() {
        return new AndFilter(Filters.toFilters(this.fields));
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        TreeRangeSet retSet = null;
        for (DimFilter field : this.fields) {
            RangeSet<String> rangeSet = field.getDimensionRangeSet(dimension);
            if (rangeSet == null) continue;
            if (retSet == null) {
                retSet = TreeRangeSet.create(rangeSet);
                continue;
            }
            retSet.removeAll(rangeSet.complement());
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        HashSet<String> requiredColumns = new HashSet<String>();
        this.fields.forEach(field -> requiredColumns.addAll(field.getRequiredColumns()));
        return requiredColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndDimFilter that = (AndDimFilter)o;
        return !(this.fields != null ? !this.fields.equals(that.fields) : that.fields != null);
    }

    public int hashCode() {
        return this.fields != null ? this.fields.hashCode() : 0;
    }

    public String toString() {
        return StringUtils.format((String)"(%s)", (Object[])new Object[]{AND_JOINER.join(this.fields)});
    }
}

