/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.testing.clients.AbstractQueryResourceTestClient;
import org.apache.druid.testing.tools.IntegrationTestingConfig;
import org.apache.druid.testing.utils.AbstractQueryWithResults;
import org.apache.druid.testing.utils.QueryResultVerifier;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.joda.time.Interval;

public abstract class AbstractTestQueryHelper<QueryResultType extends AbstractQueryWithResults> {
    public static final Logger LOG = new Logger(TestQueryHelper.class);
    protected final AbstractQueryResourceTestClient queryClient;
    protected final ObjectMapper jsonMapper;
    protected final String broker;
    protected final String brokerTLS;
    protected final String router;
    protected final String routerTLS;

    @Inject
    AbstractTestQueryHelper(ObjectMapper jsonMapper, AbstractQueryResourceTestClient<?> queryClient, IntegrationTestingConfig config) {
        this(jsonMapper, queryClient, config.getBrokerUrl(), config.getBrokerTLSUrl(), config.getRouterUrl(), config.getRouterTLSUrl());
    }

    AbstractTestQueryHelper(ObjectMapper jsonMapper, AbstractQueryResourceTestClient<?> queryClient, String broker, String brokerTLS, String router, String routerTLS) {
        this.jsonMapper = jsonMapper;
        this.queryClient = queryClient;
        this.broker = broker;
        this.brokerTLS = brokerTLS;
        this.router = router;
        this.routerTLS = routerTLS;
    }

    public abstract String getQueryURL(String var1);

    public String getCancelUrl(String schemaAndHost, String idToCancel) {
        return StringUtils.format((String)"%s/%s", (Object[])new Object[]{this.getQueryURL(schemaAndHost), idToCancel});
    }

    public void testQueriesFromFile(String filePath) throws Exception {
        this.testQueriesFromFile(this.getQueryURL(this.broker), filePath);
        this.testQueriesFromFile(this.getQueryURL(this.brokerTLS), filePath);
        this.testQueriesFromFile(this.getQueryURL(this.router), filePath);
        this.testQueriesFromFile(this.getQueryURL(this.routerTLS), filePath);
    }

    public void testQueriesFromString(String str) throws Exception {
        this.testQueriesFromString(this.getQueryURL(this.broker), str);
        if (!this.broker.equals(this.brokerTLS)) {
            this.testQueriesFromString(this.getQueryURL(this.brokerTLS), str);
        }
        this.testQueriesFromString(this.getQueryURL(this.router), str);
        if (!this.router.equals(this.routerTLS)) {
            this.testQueriesFromString(this.getQueryURL(this.routerTLS), str);
        }
    }

    public void testQueriesFromFile(String url, String filePath) throws Exception {
        LOG.info("Starting query tests for [%s]", new Object[]{filePath});
        List queries = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(filePath), new TypeReference<List<QueryResultType>>(){});
        this.testQueries(url, queries);
    }

    public void testQueriesFromString(String url, String str) throws Exception {
        List queries = (List)this.jsonMapper.readValue(str, new TypeReference<List<QueryResultType>>(){});
        this.testQueries(url, queries);
    }

    private void testQueries(String url, List<QueryResultType> queries) throws Exception {
        LOG.info("Testing [%d] queries from url[%s]", new Object[]{queries.size(), url});
        int queryIndex = 0;
        for (AbstractQueryWithResults queryWithResult : queries) {
            List<Map<String, Object>> result = this.queryClient.query(url, queryWithResult.getQuery(), queryWithResult.getDescription());
            QueryResultVerifier.ResultVerificationObject resultsComparison = QueryResultVerifier.compareResults(result, (Iterable)queryWithResult.getExpectedResults(), (List)queryWithResult.getFieldsToTest());
            if (!resultsComparison.isSuccess()) {
                LOG.error("Failed while executing query %s \n expectedResults: %s \n actualResults : %s", new Object[]{queryWithResult.getQuery(), this.jsonMapper.writeValueAsString((Object)queryWithResult.getExpectedResults()), this.jsonMapper.writeValueAsString(result)});
                throw new ISE("Results mismatch while executing the query %s.\nMismatch error: %s\n", new Object[]{queryWithResult.getQuery(), resultsComparison.getErrorMessage()});
            }
            LOG.info("Results Verified for Query[%d: %s]", new Object[]{queryIndex++, queryWithResult.getDescription()});
        }
    }

    public long countRows(String dataSource, Interval interval, Function<String, AggregatorFactory> countAggregator) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(dataSource).aggregators((List)ImmutableList.of((Object)countAggregator.apply("rows"))).granularity(Granularities.ALL).intervals(Collections.singletonList(interval)).build();
        List<Map<String, Object>> results = this.queryClient.query(this.getQueryURL(this.broker), query, "Get row count");
        if (results.isEmpty()) {
            return 0L;
        }
        Map map = (Map)results.get(0).get("result");
        Integer rowCount = (Integer)map.get("rows");
        return rowCount == null ? 0L : (long)rowCount.intValue();
    }
}

