/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.report.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.overlord.http.TaskPayloadResponse;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.apache.druid.testing.clients.TaskResponseObject;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.tools.ITRetryUtil;
import org.apache.druid.testing.tools.IntegrationTestingConfig;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class OverlordResourceTestClient {
    private static final Logger LOG = new Logger(OverlordResourceTestClient.class);
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String indexer;

    @Inject
    protected OverlordResourceTestClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.indexer = config.getOverlordUrl();
    }

    protected String getIndexerURL() {
        return StringUtils.format((String)"%s/druid/indexer/v1/", (Object[])new Object[]{this.indexer});
    }

    public String submitTask(String task) {
        try {
            return (String)RetryUtils.retry(() -> {
                StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getIndexerURL() + "task")).setContent("application/json", StringUtils.toUtf8((String)task)), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
                if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                    throw new ISE("Error while submitting task to indexer response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
                }
                Map responseData = (Map)this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING);
                String taskID = (String)responseData.get("task");
                LOG.debug("Submitted task with TaskID[%s]", new Object[]{taskID});
                return taskID;
            }, (Predicate)Predicates.alwaysTrue(), (int)5);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StatusResponseHolder submitTaskAndReturnStatusWithAuth(String task, String username, String password) throws Exception {
        return (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getIndexerURL() + "task")).setContent("application/json", StringUtils.toUtf8((String)task)).setBasicAuthentication(username, password), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
    }

    public TaskStatusPlus getTaskStatus(String taskID) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, StringUtils.format((String)"%stask/%s/status", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)taskID)}));
            LOG.debug("Index status response" + response.getContent(), new Object[0]);
            TaskStatusResponse taskStatusResponse = (TaskStatusResponse)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<TaskStatusResponse>(){});
            return taskStatusResponse.getStatus();
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StatusResponseHolder handoffTaskGroupEarly(String dataSource, String taskGroups) {
        try {
            LOG.info("handing off %s %s", new Object[]{dataSource, taskGroups});
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%ssupervisor/%s/taskGroups/handoff", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)dataSource)}))).setContent("application/json", StringUtils.toUtf8((String)taskGroups)), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            LOG.info("Handoff early response code " + response.getStatus().getCode(), new Object[0]);
            LOG.info("Handoff early response " + response.getContent(), new Object[0]);
            return response;
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<TaskResponseObject> getAllTasks() {
        return this.getTasks("tasks");
    }

    public List<TaskResponseObject> getRunningTasks() {
        return this.getTasks("runningTasks");
    }

    public List<TaskResponseObject> getWaitingTasks() {
        return this.getTasks("waitingTasks");
    }

    public List<TaskResponseObject> getPendingTasks() {
        return this.getTasks("pendingTasks");
    }

    public List<TaskResponseObject> getCompleteTasksForDataSource(String dataSource) {
        return this.getTasks(StringUtils.format((String)"tasks?state=complete&datasource=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource)}));
    }

    public List<TaskResponseObject> getUncompletedTasksForDataSource(String dataSource) {
        ArrayList<TaskResponseObject> uncompletedTasks = new ArrayList<TaskResponseObject>();
        uncompletedTasks.addAll(this.getTasks(StringUtils.format((String)"tasks?state=pending&datasource=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource)})));
        uncompletedTasks.addAll(this.getTasks(StringUtils.format((String)"tasks?state=running&datasource=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource)})));
        uncompletedTasks.addAll(this.getTasks(StringUtils.format((String)"tasks?state=waiting&datasource=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource)})));
        return uncompletedTasks;
    }

    private List<TaskResponseObject> getTasks(String identifier) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, StringUtils.format((String)"%s%s", (Object[])new Object[]{this.getIndexerURL(), identifier}));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tasks %s response %s", new Object[]{identifier, response.getContent()});
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<TaskResponseObject>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TaskPayloadResponse getTaskPayload(String taskId) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, StringUtils.format((String)"%stask/%s", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)taskId)}));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Task %s response %s", new Object[]{taskId, response.getContent()});
            }
            return (TaskPayloadResponse)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<TaskPayloadResponse>(){});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getTaskLog(String taskId) {
        return this.getTaskLog(taskId, -88000L);
    }

    public String getTaskLog(String taskId, long offsetValue) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, StringUtils.format((String)"%s%s", (Object[])new Object[]{this.getIndexerURL(), StringUtils.format((String)"task/%s/log?offset=%s", (Object[])new Object[]{StringUtils.urlEncode((String)taskId), offsetValue})}));
            return response.getContent();
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getTaskErrorMessage(String taskId) {
        return ((IngestionStatsAndErrorsTaskReport)this.getTaskReport(taskId).get((Object)"ingestionStatsAndErrors")).getPayload().getErrorMsg();
    }

    public RowIngestionMetersTotals getTaskStats(String taskId) {
        try {
            Object buildSegment = ((IngestionStatsAndErrorsTaskReport)this.getTaskReport(taskId).get((Object)"ingestionStatsAndErrors")).getPayload().getRowStats().get("buildSegments");
            return (RowIngestionMetersTotals)this.jsonMapper.convertValue(buildSegment, RowIngestionMetersTotals.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TaskReport.ReportMap getTaskReport(String taskId) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, StringUtils.format((String)"%s%s", (Object[])new Object[]{this.getIndexerURL(), StringUtils.format((String)"task/%s/reports", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})}));
            return (TaskReport.ReportMap)this.jsonMapper.readValue(response.getContent(), TaskReport.ReportMap.class);
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<Interval>> getLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
        try {
            String jsonBody = this.jsonMapper.writeValueAsString(lockFilterPolicies);
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getIndexerURL() + "lockedIntervals/v2")).setContent("application/json", StringUtils.toUtf8((String)jsonBody)), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, List<Interval>>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void waitUntilTaskCompletes(String taskId) {
        ITRetryUtil.retryUntilEquals(() -> {
            TaskState status = this.getTaskStatus(taskId).getStatusCode();
            if (status == TaskState.FAILED) {
                throw new ISE("Task[%s] failed with error[%s]", new Object[]{taskId, this.getTaskErrorMessage(taskId)});
            }
            return status;
        }, (Object)TaskState.SUCCESS, (String)StringUtils.format((String)"Status of task[%s]", (Object[])new Object[]{taskId}));
    }

    public void waitUntilTaskFails(String taskID) {
        this.waitUntilTaskFails(taskID, 10000L, 60);
    }

    public void waitUntilTaskFails(String taskId, long millisEach, int numTimes) {
        ITRetryUtil.retryUntilEquals(() -> {
            TaskState status = this.getTaskStatus(taskId).getStatusCode();
            if (status == TaskState.SUCCESS) {
                throw new ISE("Task[%s] has SUCCEEDED. It was expected to fail.", new Object[]{taskId});
            }
            return status;
        }, (Object)TaskState.FAILED, (long)millisEach, (int)numTimes, (String)StringUtils.format((String)"Status of task[%s]", (Object[])new Object[]{taskId}));
    }

    public String submitSupervisor(String spec) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getIndexerURL() + "supervisor")).setContent("application/json", StringUtils.toUtf8((String)spec)), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while submitting supervisor to overlord, response [%s: %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            Map responseData = (Map)this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING);
            String id = (String)responseData.get("id");
            LOG.debug("Submitted supervisor with id[%s]", new Object[]{id});
            return id;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdownSupervisor(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%ssupervisor/%s/shutdown", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while shutting down supervisor, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("Shutdown supervisor with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void terminateSupervisor(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%ssupervisor/%s/terminate", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while terminating supervisor, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("Terminate supervisor with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdownTask(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%stask/%s/shutdown", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while shutdown task, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("Shutdown task with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SupervisorStateManager.BasicState getSupervisorStatus(String id) {
        String state = (String)this.getFullSupervisorStatus(id).get("state");
        LOG.debug("Supervisor id[%s] has state [%s]", new Object[]{id, state});
        return SupervisorStateManager.BasicState.valueOf((String)state);
    }

    public Map<String, Object> getFullSupervisorStatus(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%ssupervisor/%s/status", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while getting supervisor status, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            Map responseData = (Map)this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            return (Map)this.jsonMapper.convertValue(responseData.get("payload"), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void suspendSupervisor(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%ssupervisor/%s/suspend", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while suspending supervisor, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("Suspended supervisor with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void statsSupervisor(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%ssupervisor/%s/stats", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while stats supervisor, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("stats supervisor with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void getSupervisorHealth(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%ssupervisor/%s/health", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while get supervisor health, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("get supervisor health with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void resumeSupervisor(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%ssupervisor/%s/resume", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while resuming supervisor, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("Resumed supervisor with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void resetSupervisor(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%ssupervisor/%s/reset", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while resetting supervisor, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.debug("Reset supervisor with id[%s]", new Object[]{id});
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> getSupervisorHistory(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%ssupervisor/%s/history", (Object[])new Object[]{this.getIndexerURL(), StringUtils.urlEncode((String)id)}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while getting supervisor status, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            List responseData = (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<Object>>(){});
            return responseData;
        }
        catch (ISE e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected StatusResponseHolder makeRequest(HttpMethod method, String url) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(method, new URL(url)), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while making request to indexer [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            return response;
        }
        catch (ISE e) {
            LOG.error("Exception while sending request: %s", new Object[]{e.getMessage()});
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Exception while sending request", new Object[0]);
            throw new RuntimeException(e);
        }
    }
}

