/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.ServerManager;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class ServerManagerForQueryErrorTest
extends ServerManager {
    public static final String QUERY_RETRY_TEST_CONTEXT_KEY = "query-retry-test";
    public static final String QUERY_TIMEOUT_TEST_CONTEXT_KEY = "query-timeout-test";
    public static final String QUERY_CAPACITY_EXCEEDED_TEST_CONTEXT_KEY = "query-capacity-exceeded-test";
    public static final String QUERY_UNSUPPORTED_TEST_CONTEXT_KEY = "query-unsupported-test";
    public static final String RESOURCE_LIMIT_EXCEEDED_TEST_CONTEXT_KEY = "resource-limit-exceeded-test";
    public static final String QUERY_FAILURE_TEST_CONTEXT_KEY = "query-failure-test";
    public static final String QUERY_RETRY_UNAVAILABLE_SEGMENT_IDX_KEY = "unavailable-segment-idx";
    private static final int MAX_NUM_FALSE_MISSING_SEGMENTS_REPORTS = 1;
    private static final Logger LOG = new Logger(ServerManagerForQueryErrorTest.class);
    private final ConcurrentHashMap<String, Integer> queryToIgnoredSegments = new ConcurrentHashMap();

    @Inject
    public ServerManagerForQueryErrorTest(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, QueryProcessingPool queryProcessingPool, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, ServerConfig serverConfig) {
        super(conglomerate, emitter, queryProcessingPool, cachePopulator, objectMapper, cache, cacheConfig, segmentManager, serverConfig, (PolicyEnforcer)NoopPolicyEnforcer.instance());
    }

    protected <T> FunctionalIterable<QueryRunner<T>> getQueryRunnersForSegments(VersionedIntervalTimeline<String, DataSegment> timeline, Iterable<SegmentDescriptor> specs, Query<T> query, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, SegmentMapFunction segmentMapFn, AtomicLong cpuTimeAccumulator, Optional<byte[]> cacheKeyPrefix, Closer closer) {
        return FunctionalIterable.create((Iterable)this.getSegmentReferences(timeline, specs, segmentMapFn, query.context().getTimeout())).transform(ref -> ref.getSegmentReference().map(segment -> {
            QueryContext queryContext = query.context();
            if (queryContext.getBoolean(QUERY_RETRY_TEST_CONTEXT_KEY, false)) {
                int unavailableSegmentIdx = queryContext.getInt(QUERY_RETRY_UNAVAILABLE_SEGMENT_IDX_KEY, -1);
                MutableBoolean isIgnoreSegment = new MutableBoolean(false);
                this.queryToIgnoredSegments.compute(query.getMostSpecificId(), (queryId, ignoreCounter) -> {
                    if (ignoreCounter == null) {
                        ignoreCounter = 0;
                    }
                    if (unavailableSegmentIdx >= 0 && unavailableSegmentIdx == ignoreCounter) {
                        Integer n = ignoreCounter;
                        ignoreCounter = ignoreCounter + 1;
                        isIgnoreSegment.setTrue();
                    } else if (ignoreCounter < 1) {
                        Integer n = ignoreCounter;
                        ignoreCounter = ignoreCounter + 1;
                        isIgnoreSegment.setTrue();
                    }
                    return ignoreCounter;
                });
                if (isIgnoreSegment.isTrue()) {
                    LOG.info("Pretending I don't have segment[%s]", new Object[]{ref.getSegmentDescriptor()});
                    return new ReportTimelineMissingSegmentQueryRunner(ref.getSegmentDescriptor());
                }
            } else {
                if (queryContext.getBoolean(QUERY_TIMEOUT_TEST_CONTEXT_KEY, false)) {
                    return (queryPlus, responseContext) -> new Sequence<T>(){

                        public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                            throw new QueryTimeoutException("query timeout test");
                        }

                        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                            throw new QueryTimeoutException("query timeout test");
                        }
                    };
                }
                if (queryContext.getBoolean(QUERY_CAPACITY_EXCEEDED_TEST_CONTEXT_KEY, false)) {
                    return (queryPlus, responseContext) -> new Sequence<T>(){

                        public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                            throw QueryCapacityExceededException.withErrorMessageAndResolvedHost((String)"query capacity exceeded test");
                        }

                        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                            throw QueryCapacityExceededException.withErrorMessageAndResolvedHost((String)"query capacity exceeded test");
                        }
                    };
                }
                if (queryContext.getBoolean(QUERY_UNSUPPORTED_TEST_CONTEXT_KEY, false)) {
                    return (queryPlus, responseContext) -> new Sequence<T>(){

                        public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                            throw new QueryUnsupportedException("query unsupported test");
                        }

                        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                            throw new QueryUnsupportedException("query unsupported test");
                        }
                    };
                }
                if (queryContext.getBoolean(RESOURCE_LIMIT_EXCEEDED_TEST_CONTEXT_KEY, false)) {
                    return (queryPlus, responseContext) -> new Sequence<T>(){

                        public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                            throw new ResourceLimitExceededException("resource limit exceeded test");
                        }

                        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                            throw new ResourceLimitExceededException("resource limit exceeded test");
                        }
                    };
                }
                if (queryContext.getBoolean(QUERY_FAILURE_TEST_CONTEXT_KEY, false)) {
                    return (queryPlus, responseContext) -> new Sequence<T>(){

                        public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                            throw new RuntimeException("query failure test");
                        }

                        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                            throw new RuntimeException("query failure test");
                        }
                    };
                }
            }
            return this.buildQueryRunnerForSegment(ref.getSegmentDescriptor(), (Segment)segment, factory, toolChest, cpuTimeAccumulator, cacheKeyPrefix);
        }).orElse((QueryRunner)new ReportTimelineMissingSegmentQueryRunner(ref.getSegmentDescriptor())));
    }
}

