/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.net.URL;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class HttpUtil {
    private static final Logger LOG = new Logger(HttpUtil.class);
    private static final StatusResponseHandler RESPONSE_HANDLER = StatusResponseHandler.getInstance();
    static final int NUM_RETRIES = 30;
    static final long DELAY_FOR_RETRIES_MS = 10000L;

    public static StatusResponseHolder makeRequest(HttpClient httpClient, HttpMethod method, String url, byte[] content) {
        return HttpUtil.makeRequestWithExpectedStatus(httpClient, method, url, content, HttpResponseStatus.OK);
    }

    public static StatusResponseHolder makeRequestWithExpectedStatus(HttpClient httpClient, HttpMethod method, String url, @Nullable byte[] content, HttpResponseStatus expectedStatus) {
        try {
            StatusResponseHolder response;
            Request request = new Request(method, new URL(url));
            if (content != null) {
                request.setContent("application/json", content);
            }
            int retryCount = 0;
            while (!(response = (StatusResponseHolder)httpClient.go(request, (HttpResponseHandler)RESPONSE_HANDLER).get()).getStatus().equals((Object)expectedStatus)) {
                String errMsg = StringUtils.format((String)"Error while making request to url[%s] status[%s] content[%s]", (Object[])new Object[]{url, response.getStatus(), response.getContent()});
                if (retryCount > 30) {
                    throw new ISE(errMsg, new Object[0]);
                }
                LOG.error(errMsg, new Object[0]);
                LOG.error("retrying in 3000ms, retryCount: " + retryCount, new Object[0]);
                ++retryCount;
                Thread.sleep(10000L);
            }
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HttpUtil() {
    }
}

