/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.joda.time.DateTime;

public class MapInputRowParser
implements InputRowParser<Map<String, Object>> {
    private final ParseSpec parseSpec;

    @JsonCreator
    public MapInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec) {
        this.parseSpec = parseSpec;
    }

    @Override
    public List<InputRow> parseBatch(Map<String, Object> theMap) {
        DateTime timestamp;
        ArrayList dimensions = this.parseSpec.getDimensionsSpec().hasCustomDimensions() ? this.parseSpec.getDimensionsSpec().getDimensionNames() : Lists.newArrayList((Iterable)Sets.difference(theMap.keySet(), this.parseSpec.getDimensionsSpec().getDimensionExclusions()));
        try {
            timestamp = this.parseSpec.getTimestampSpec().extractTimestamp(theMap);
            if (timestamp == null) {
                String input = theMap.toString();
                throw new NullPointerException(StringUtils.format((String)"Null timestamp in input: %s", (Object[])new Object[]{input.length() < 100 ? input : input.substring(0, 100) + "..."}));
            }
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e, "Unparseable timestamp found! Event: %s", new Object[]{theMap});
        }
        return ImmutableList.of((Object)new MapBasedInputRow(timestamp.getMillis(), (List<String>)dimensions, theMap));
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new MapInputRowParser(parseSpec);
    }
}

